/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.base;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.enums.SqlMethod;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.SqlHelper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.ReflectionKit;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Transactional;
import top.ibase4j.core.base.BaseMapper;
import top.ibase4j.core.base.BaseModel;
import top.ibase4j.core.base.IBaseService;
import top.ibase4j.core.exception.BusinessException;
import top.ibase4j.core.support.Pagination;
import top.ibase4j.core.support.cache.CacheKey;
import top.ibase4j.core.support.dbcp.HandleDataSource;
import top.ibase4j.core.util.CacheUtil;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.ExceptionUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;

public abstract class BaseService<T extends BaseModel, M extends BaseMapper<T>>
implements IBaseService<T> {
    protected Logger logger = LogManager.getLogger();
    @Autowired
    protected M mapper;
    int maxThread = PropertiesUtil.getInt("db.reader.list.maxThread", 50);
    int threadSleep = PropertiesUtil.getInt("db.reader.list.threadWait", 5);
    ExecutorService executorService = Executors.newFixedThreadPool(this.maxThread);

    public static Page<Long> getPage(Map<String, Object> params) {
        Object filter;
        Integer current = 1;
        Integer size = 10;
        String orderBy = "id_";
        String sortAsc = null;
        String openSort = "Y";
        if (DataUtil.isNotEmpty(params.get("pageNumber"))) {
            current = Integer.valueOf(params.get("pageNumber").toString());
        }
        if (DataUtil.isNotEmpty(params.get("pageIndex"))) {
            current = Integer.valueOf(params.get("pageIndex").toString());
        }
        if (DataUtil.isNotEmpty(params.get("pageSize"))) {
            size = Integer.valueOf(params.get("pageSize").toString());
        }
        if (DataUtil.isNotEmpty(params.get("limit"))) {
            size = Integer.valueOf(params.get("limit").toString());
        }
        if (DataUtil.isNotEmpty(params.get("offset"))) {
            current = Integer.valueOf(params.get("offset").toString()) / size + 1;
        }
        if (DataUtil.isNotEmpty(params.get("sort"))) {
            orderBy = (String)params.get("sort");
            params.remove("sort");
        }
        if (DataUtil.isNotEmpty(params.get("orderBy"))) {
            orderBy = (String)params.get("orderBy");
            params.remove("orderBy");
        }
        if (DataUtil.isNotEmpty(params.get("sortAsc"))) {
            sortAsc = (String)params.get("sortAsc");
            params.remove("sortAsc");
        }
        if (DataUtil.isNotEmpty(params.get("openSort"))) {
            openSort = (String)params.get("openSort");
            params.remove("openSort");
        }
        if ((filter = params.get("filter")) != null) {
            params.putAll((Map)JSON.parseObject((String)filter.toString(), Map.class));
        }
        if (size == -1) {
            Page page = new Page();
            page.setOrderByField(orderBy);
            page.setAsc("Y".equals(sortAsc));
            page.setOpenSort("Y".equals(openSort));
            return page;
        }
        Page page = new Page(current.intValue(), size.intValue(), orderBy);
        page.setAsc("Y".equals(sortAsc));
        page.setOpenSort("Y".equals(openSort));
        return page;
    }

    @Override
    @Transactional
    public void del(List<Long> ids, Long userId) {
        for (Long id : ids) {
            this.del(id, userId);
        }
    }

    @Override
    @Transactional
    public void del(Long id, Long userId) {
        try {
            T record = this.getById(id);
            ((BaseModel)record).setEnable(0);
            ((BaseModel)record).setUpdateTime(new Date());
            ((BaseModel)record).setUpdateBy(userId);
            this.mapper.updateById(record);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public void delete(Long id) {
        try {
            this.mapper.deleteById((Serializable)id);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public Integer deleteByEntity(T t) {
        EntityWrapper wrapper = new EntityWrapper(t);
        return this.mapper.delete((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public Integer deleteByMap(Map<String, Object> columnMap) {
        return this.mapper.deleteByMap(columnMap);
    }

    public Pagination<Map<String, Object>> getPageMap(final Page<Long> ids) {
        if (ids != null) {
            Pagination<Map<String, Object>> page = new Pagination<Map<String, Object>>(ids.getCurrent(), ids.getSize());
            page.setTotal(ids.getTotal());
            final ArrayList records = InstanceUtil.newArrayList();
            for (int i = 0; i < ids.getRecords().size(); ++i) {
                records.add(null);
            }
            final ConcurrentHashMap thread = InstanceUtil.newConcurrentHashMap();
            final String datasource = HandleDataSource.getDataSource();
            int i = 0;
            while (i < ids.getRecords().size()) {
                final int index = i++;
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        HandleDataSource.putDataSource(datasource);
                        try {
                            records.set(index, InstanceUtil.transBean2Map(BaseService.this.getById((Long)ids.getRecords().get(index))));
                        }
                        finally {
                            thread.put(index, 0);
                        }
                    }
                });
            }
            while (thread.size() < records.size()) {
                try {
                    Thread.sleep(this.threadSleep);
                }
                catch (InterruptedException e) {
                    this.logger.error("", (Throwable)e);
                }
            }
            page.setRecords(records);
            return page;
        }
        return new Pagination<Map<String, Object>>();
    }

    @Override
    public Pagination<T> query(Map<String, Object> params) {
        Page<Long> page = BaseService.getPage(params);
        page.setRecords(this.mapper.selectIdPage((RowBounds)page, params));
        return this.getPage(page);
    }

    @Override
    public Pagination<T> query(T entity, Pagination<T> rowBounds) {
        Page page = new Page();
        try {
            PropertyUtils.copyProperties((Object)page, rowBounds);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.error("", (Throwable)e);
        }
        EntityWrapper wrapper = new EntityWrapper(entity);
        List list = this.mapper.selectPage((RowBounds)page, (Wrapper)wrapper);
        for (BaseModel t : list) {
            this.saveCache(t);
        }
        Pagination pager = new Pagination(page.getCurrent(), page.getSize());
        pager.setRecords(list);
        pager.setTotal(this.mapper.selectCount((Wrapper)wrapper));
        return pager;
    }

    @Override
    public T queryById(Long id) {
        return this.queryById(id, 1);
    }

    @Override
    public List<T> queryList(Map<String, Object> params) {
        if (DataUtil.isEmpty(params.get("orderBy"))) {
            params.put("orderBy", "id_");
        } else if (DataUtil.checkSQLInject(params.get("orderBy").toString())) {
            throw new RuntimeException("\u975e\u6cd5\u64cd\u4f5c.");
        }
        if (DataUtil.isEmpty(params.get("sortAsc"))) {
            params.put("sortAsc", "desc");
        } else if (DataUtil.checkSQLInject(params.get("sortAsc").toString())) {
            throw new RuntimeException("\u975e\u6cd5\u64cd\u4f5c.");
        }
        List<Long> ids = this.mapper.selectIdPage(params);
        List<T> list = this.queryList(ids);
        return list;
    }

    @Override
    public List<T> queryList(T params) {
        List<Long> ids = this.mapper.selectIdPage(params);
        List<T> list = this.queryList(ids);
        return list;
    }

    @Override
    public List<T> queryList(final List<Long> ids) {
        final ArrayList list = InstanceUtil.newArrayList();
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                list.add(null);
            }
            final ConcurrentHashMap thread = InstanceUtil.newConcurrentHashMap();
            final String datasource = HandleDataSource.getDataSource();
            int i = 0;
            while (i < ids.size()) {
                final int index = i++;
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        HandleDataSource.putDataSource(datasource);
                        try {
                            list.set(index, BaseService.this.getById((Long)ids.get(index)));
                        }
                        finally {
                            thread.put(index, 0);
                        }
                    }
                });
            }
            while (thread.size() < list.size()) {
                try {
                    Thread.sleep(this.threadSleep);
                }
                catch (InterruptedException e) {
                    this.logger.error("", (Throwable)e);
                }
            }
        }
        return list;
    }

    @Override
    public <K> List<K> queryList(final List<Long> ids, final Class<K> cls) {
        final ArrayList list = InstanceUtil.newArrayList();
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                list.add(null);
            }
            final ConcurrentHashMap thread = InstanceUtil.newConcurrentHashMap();
            final String datasource = HandleDataSource.getDataSource();
            int i = 0;
            while (i < ids.size()) {
                final int index = i++;
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        HandleDataSource.putDataSource(datasource);
                        try {
                            BaseModel t = BaseService.this.getById((Long)ids.get(index));
                            Object k = InstanceUtil.to(t, cls);
                            list.set(index, k);
                        }
                        finally {
                            thread.put(index, 0);
                        }
                    }
                });
            }
            while (thread.size() < list.size()) {
                try {
                    Thread.sleep(this.threadSleep);
                }
                catch (InterruptedException e) {
                    this.logger.error("", (Throwable)e);
                }
            }
        }
        return list;
    }

    @Override
    public T selectOne(T entity) {
        BaseModel t = (BaseModel)this.mapper.selectOne(entity);
        this.saveCache(t);
        return (T)t;
    }

    @Override
    @Transactional
    public T update(T record) {
        try {
            ((BaseModel)record).setUpdateTime(new Date());
            if (((BaseModel)record).getId() == null) {
                ((BaseModel)record).setCreateTime(new Date());
                this.mapper.insert(record);
            } else {
                String lockKey = this.getLockKey("U" + ((BaseModel)record).getId());
                if (CacheUtil.getLock(lockKey, "\u66f4\u65b0")) {
                    try {
                        this.mapper.updateById(record);
                    }
                    finally {
                        CacheUtil.unLock(lockKey);
                    }
                } else {
                    throw new RuntimeException("\u6570\u636e\u4e0d\u4e00\u81f4!\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u7f16\u8f91!");
                }
            }
            record = (BaseModel)this.mapper.selectById((Serializable)((BaseModel)record).getId());
            this.saveCache(record);
        }
        catch (DuplicateKeyException e) {
            this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
            throw new BusinessException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55.");
        }
        catch (Exception e) {
            this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
            throw new RuntimeException(ExceptionUtil.getStackTraceAsString(e));
        }
        return record;
    }

    @Override
    @Transactional
    public T updateAllColumn(T record) {
        try {
            ((BaseModel)record).setUpdateTime(new Date());
            if (((BaseModel)record).getId() == null) {
                ((BaseModel)record).setCreateTime(new Date());
                this.mapper.insert(record);
            } else {
                String lockKey = this.getLockKey("U" + ((BaseModel)record).getId());
                if (CacheUtil.getLock(lockKey, "\u66f4\u65b0\u6240\u6709\u5b57\u6bb5")) {
                    try {
                        this.mapper.updateAllColumnById(record);
                    }
                    finally {
                        CacheUtil.unLock(lockKey);
                    }
                } else {
                    throw new RuntimeException("\u6570\u636e\u4e0d\u4e00\u81f4!\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u7f16\u8f91!");
                }
            }
            record = (BaseModel)this.mapper.selectById((Serializable)((BaseModel)record).getId());
            this.saveCache(record);
        }
        catch (DuplicateKeyException e) {
            this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
            throw new BusinessException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55.");
        }
        catch (Exception e) {
            this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
            throw new RuntimeException(ExceptionUtil.getStackTraceAsString(e));
        }
        return record;
    }

    @Override
    @Transactional
    public boolean updateAllColumnBatch(List<T> entityList) {
        return this.updateAllColumnBatch(entityList, 30);
    }

    @Override
    @Transactional
    public boolean updateAllColumnBatch(List<T> entityList, int batchSize) {
        return this.updateBatch(entityList, batchSize, false);
    }

    @Override
    @Transactional
    public boolean updateBatch(List<T> entityList) {
        return this.updateBatch(entityList, 30);
    }

    @Override
    @Transactional
    public boolean updateBatch(List<T> entityList, int batchSize) {
        return this.updateBatch(entityList, batchSize, true);
    }

    protected Class<T> currentModelClass() {
        return ReflectionKit.getSuperClassGenricType(this.getClass(), (int)0);
    }

    protected String getLockKey(Object id) {
        CacheKey cacheKey = CacheKey.getInstance(this.getClass());
        StringBuilder sb = new StringBuilder();
        if (cacheKey == null) {
            sb.append(this.getClass().getName());
        } else {
            sb.append(cacheKey.getValue());
        }
        return sb.append(":LOCK:").append(id).toString();
    }

    @Override
    protected <P> Pagination<P> query(Map<String, Object> params, Class<P> cls) {
        Page<Long> page = BaseService.getPage(params);
        page.setRecords(this.mapper.selectIdPage((RowBounds)page, params));
        return this.getPage(page, cls);
    }

    protected void sleep(int millis) {
        try {
            Thread.sleep(RandomUtils.nextLong((long)10L, (long)millis));
        }
        catch (InterruptedException e) {
            this.logger.error("", (Throwable)e);
        }
    }

    protected SqlSession sqlSessionBatch() {
        return SqlHelper.sqlSessionBatch(this.currentModelClass());
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.table(this.currentModelClass()).getSqlStatement(sqlMethod.getMethod());
    }

    private T getById(Long id) {
        return this.queryById(id, 1);
    }

    protected Pagination<T> getPage(final Page<Long> ids) {
        if (ids != null) {
            Pagination page = new Pagination(ids.getCurrent(), ids.getSize());
            page.setTotal(ids.getTotal());
            final ArrayList records = InstanceUtil.newArrayList();
            for (int i = 0; i < ids.getRecords().size(); ++i) {
                records.add(null);
            }
            final ConcurrentHashMap thread = InstanceUtil.newConcurrentHashMap();
            final String datasource = HandleDataSource.getDataSource();
            int i = 0;
            while (i < ids.getRecords().size()) {
                final int index = i++;
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        HandleDataSource.putDataSource(datasource);
                        try {
                            records.set(index, BaseService.this.getById((Long)ids.getRecords().get(index)));
                        }
                        finally {
                            thread.put(index, 0);
                        }
                    }
                });
            }
            while (thread.size() < records.size()) {
                try {
                    Thread.sleep(this.threadSleep);
                }
                catch (InterruptedException e) {
                    this.logger.error("", (Throwable)e);
                }
            }
            page.setRecords(records);
            return page;
        }
        return new Pagination();
    }

    private <K> Pagination<K> getPage(final Page<Long> ids, final Class<K> cls) {
        if (ids != null) {
            Pagination page = new Pagination(ids.getCurrent(), ids.getSize());
            page.setTotal(ids.getTotal());
            final ArrayList records = InstanceUtil.newArrayList();
            for (int i = 0; i < ids.getRecords().size(); ++i) {
                records.add(null);
            }
            final ConcurrentHashMap thread = InstanceUtil.newConcurrentHashMap();
            final String datasource = HandleDataSource.getDataSource();
            int i = 0;
            while (i < ids.getRecords().size()) {
                final int index = i++;
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        HandleDataSource.putDataSource(datasource);
                        try {
                            BaseModel t = BaseService.this.getById((Long)ids.getRecords().get(index));
                            Object k = InstanceUtil.to(t, cls);
                            records.set(index, k);
                        }
                        finally {
                            thread.put(index, 0);
                        }
                    }
                });
            }
            while (thread.size() < records.size()) {
                try {
                    Thread.sleep(this.threadSleep);
                }
                catch (InterruptedException e) {
                    this.logger.error("", (Throwable)e);
                }
            }
            page.setRecords(records);
            return page;
        }
        return new Pagination();
    }

    private void saveCache(T record) {
        if (record == null) {
            return;
        }
        CacheKey key = CacheKey.getInstance(this.getClass());
        if (key != null) {
            try {
                CacheUtil.getCache().set(key.getValue() + ":" + ((BaseModel)record).getId(), (Serializable)record, key.getTimeToLive());
            }
            catch (Exception e) {
                this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T queryById(Long id, int times) {
        CacheKey key = CacheKey.getInstance(this.getClass());
        BaseModel record = null;
        if (key != null) {
            try {
                record = (BaseModel)CacheUtil.getCache().get(key.getValue() + ":" + id, key.getTimeToLive());
            }
            catch (Exception e) {
                this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)e);
            }
        }
        if (record == null) {
            String lockKey = this.getLockKey(id);
            if (CacheUtil.getLock(lockKey, "\u6839\u636eID\u67e5\u8be2\u6570\u636e")) {
                try {
                    record = (BaseModel)this.mapper.selectById((Serializable)id);
                    this.saveCache(record);
                }
                finally {
                    CacheUtil.unLock(lockKey);
                }
            } else if (times > 3) {
                record = (BaseModel)this.mapper.selectById((Serializable)id);
                this.saveCache(record);
            } else {
                this.logger.debug(this.getClass().getSimpleName() + ":" + id + " retry getById.");
                this.sleep(20);
                return this.queryById(id, times + 1);
            }
        }
        return (T)record;
    }

    private boolean updateBatch(List<T> entityList, int batchSize, boolean selective) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = entityList.size();
            for (int i = 0; i < size; ++i) {
                if (selective) {
                    this.update((BaseModel)entityList.get(i));
                } else {
                    this.updateAllColumn((BaseModel)entityList.get(i));
                }
                if (i < 1 || i % batchSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        return true;
    }
}

