package top.ibase4j.core.config;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import top.ibase4j.core.Constants;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;
import top.ibase4j.core.util.SecurityUtil;

/**
 * @author ShenHuaJie
 * @since 2017年8月15日 上午9:03:17
 */
@Configuration
public class Configs implements EnvironmentPostProcessor, Ordered {
    private Logger logger = LogManager.getLogger();

    @Override
    @SuppressWarnings({"unchecked", "rawtypes"})
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        Properties props = getConfig();
        propertySources.addLast(new PropertiesPropertySource("thirdEnv", props));
        for (PropertySource<?> propertySource : propertySources) {
            if (propertySource.getSource() instanceof Map) {
                Map map = (Map)propertySource.getSource();
                for (Object key : map.keySet()) {
                    String keyStr = key.toString();
                    Object value = map.get(key);
                    if ("druid.password,druid.writer.password,druid.reader.password".contains(keyStr)) {
                        String dkey = (String)map.get("druid.key");
                        dkey = DataUtil.isEmpty(dkey) ? Constants.DB_KEY : dkey;
                        value = SecurityUtil.decryptDes(value.toString(), dkey.getBytes());
                        map.put(key, value);
                    }
                    PropertiesUtil.getProperties().put(keyStr, value.toString());
                }
            }
        }
        System.out.println("* iBase4J Read configuration file finished.");
        logger.info("* iBase4J Read configuration file finished.");
    }

    @Override
    public int getOrder() {
        return ConfigFileApplicationListener.DEFAULT_ORDER + 1;
    }

    // 加载配置文件
    private Properties getConfig() {
        try {
            PropertiesFactoryBean config = new PropertiesFactoryBean();
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            List<Resource> resouceList = InstanceUtil.newArrayList();
            try {
                Resource[] resources = resolver.getResources("classpath*:config/*.properties");
                for (Resource resource : resources) {
                    resouceList.add(resource);
                }
            } catch (Exception e) {
                logger.error("", e);
            }
            config.setLocations(resouceList.toArray(new Resource[]{}));
            config.afterPropertiesSet();
            return config.getObject();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        String encrypt = SecurityUtil.encryptDes("root", Constants.DB_KEY.getBytes());
        System.out.println(encrypt);
        System.out.println(SecurityUtil.decryptDes(encrypt, Constants.DB_KEY.getBytes()));
    }
}
