/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import top.ibase4j.core.util.DataUtil;

public final class XmlUtil {
    private static Logger logger = LogManager.getLogger();

    private XmlUtil() {
    }

    public static final Map parseXml2Map(String pStrXml) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String strTitle = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        Document document = null;
        try {
            if (pStrXml.indexOf("<?xml") < 0) {
                pStrXml = strTitle + pStrXml;
            }
            document = DocumentHelper.parseText((String)pStrXml);
        }
        catch (DocumentException e) {
            logger.error("==\u5f00\u53d1\u4eba\u5458\u8bf7\u6ce8\u610f:==\n\u5c06XML\u683c\u5f0f\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3aXML DOM\u5bf9\u8c61\u65f6\u53d1\u751f\u9519\u8bef\u5566!\n\u8be6\u7ec6\u9519\u8bef\u4fe1\u606f\u5982\u4e0b:", (Throwable)e);
        }
        Element elNode = document.getRootElement();
        Iterator it = elNode.elementIterator();
        while (it.hasNext()) {
            Element leaf = (Element)it.next();
            map.put(leaf.getName().toLowerCase(), leaf.getData());
        }
        return map;
    }

    public static Map Dom2Map(Document doc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (doc == null) {
            return map;
        }
        Element root = doc.getRootElement();
        Iterator iterator = root.elementIterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            List list = e.elements();
            if (list.size() > 0) {
                map.put(e.getName(), XmlUtil.Dom2Map(e));
                continue;
            }
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    public static Map Dom2Map(Element e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element iter = (Element)list.get(i);
                List<Map> mapList = new ArrayList<Object>();
                if (iter.elements().size() > 0) {
                    Map m = XmlUtil.Dom2Map(iter);
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!obj.getClass().getName().equals("java.util.ArrayList")) {
                            mapList = new ArrayList();
                            mapList.add((Map)obj);
                            mapList.add(m);
                        }
                        if (obj.getClass().getName().equals("java.util.ArrayList")) {
                            mapList = (List)obj;
                            mapList.add(m);
                        }
                        map.put(iter.getName(), mapList);
                        continue;
                    }
                    map.put(iter.getName(), m);
                    continue;
                }
                if (map.get(iter.getName()) != null) {
                    Object obj = map.get(iter.getName());
                    if (!obj.getClass().getName().equals("java.util.ArrayList")) {
                        mapList = new ArrayList();
                        mapList.add((Map)obj);
                        mapList.add((Map)((Object)iter.getText()));
                    }
                    if (obj.getClass().getName().equals("java.util.ArrayList")) {
                        mapList = (List)obj;
                        mapList.add((Map)((Object)iter.getText()));
                    }
                    map.put(iter.getName(), mapList);
                    continue;
                }
                map.put(iter.getName(), iter.getText());
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    public static final Map parseXml2Map(String pStrXml, String pXPath) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String strTitle = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        Document document = null;
        try {
            if (pStrXml.indexOf("<?xml") < 0) {
                pStrXml = strTitle + pStrXml;
            }
            document = DocumentHelper.parseText((String)pStrXml);
        }
        catch (DocumentException e) {
            logger.error("==\u5f00\u53d1\u4eba\u5458\u8bf7\u6ce8\u610f:==\n\u5c06XML\u683c\u5f0f\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3aXML DOM\u5bf9\u8c61\u65f6\u53d1\u751f\u9519\u8bef\u5566!\n\u8be6\u7ec6\u9519\u8bef\u4fe1\u606f\u5982\u4e0b:", (Throwable)e);
        }
        Element elNode = document.getRootElement();
        Iterator it = elNode.elementIterator();
        while (it.hasNext()) {
            Element leaf = (Element)it.next();
            map.put(leaf.getName().toLowerCase(), leaf.getData());
        }
        return map;
    }

    public static final String parseDto2Xml(Map map, String pRootNodeName) {
        Document document = DocumentHelper.createDocument();
        document.addElement(pRootNodeName);
        Element root = document.getRootElement();
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            Element leaf = root.addElement(key);
            leaf.setText(value);
        }
        String outXml = document.asXML().substring(39);
        return outXml;
    }

    public static final String parseDto2XmlHasHead(Map map, String pRootNodeName) {
        Document document = DocumentHelper.createDocument();
        document.addElement(pRootNodeName);
        Element root = document.getRootElement();
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            Element leaf = root.addElement(key);
            leaf.setText(value);
        }
        String outXml = document.asXML();
        return outXml;
    }

    public static final String parseMap2Xml(Map map, String pRootNodeName, String pFirstNodeName) {
        Document document = DocumentHelper.createDocument();
        document.addElement(pRootNodeName);
        Element root = document.getRootElement();
        root.addElement(pFirstNodeName);
        Element firstEl = (Element)document.selectSingleNode("/" + pRootNodeName + "/" + pFirstNodeName);
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            firstEl.addAttribute(key, value);
        }
        String outXml = document.asXML().substring(39);
        return outXml;
    }

    public static final String parseList2Xml(List pList, String pRootNodeName, String pFirstNodeName) {
        Document document = DocumentHelper.createDocument();
        Element elRoot = document.addElement(pRootNodeName);
        for (int i = 0; i < pList.size(); ++i) {
            Map map = (Map)pList.get(i);
            Element elRow = elRoot.addElement(pFirstNodeName);
            for (Map.Entry entry : map.entrySet()) {
                elRow.addAttribute((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        String outXml = document.asXML().substring(39);
        return outXml;
    }

    public static final String parseList2XmlBasedNode(List pList, String pRootNodeName, String pFirstNodeName) {
        Document document = DocumentHelper.createDocument();
        Element output = document.addElement(pRootNodeName);
        for (int i = 0; i < pList.size(); ++i) {
            Map map = (Map)pList.get(i);
            Element elRow = output.addElement(pFirstNodeName);
            for (Map.Entry entry : map.entrySet()) {
                Element leaf = elRow.addElement((String)entry.getKey());
                leaf.setText(String.valueOf(entry.getValue()));
            }
        }
        String outXml = document.asXML().substring(39);
        return outXml;
    }

    public static final List parseXml2List(String pStrXml) {
        ArrayList lst = new ArrayList();
        String strTitle = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        Document document = null;
        try {
            if (pStrXml.indexOf("<?xml") < 0) {
                pStrXml = strTitle + pStrXml;
            }
            document = DocumentHelper.parseText((String)pStrXml);
        }
        catch (DocumentException e) {
            logger.error("==\u5f00\u53d1\u4eba\u5458\u8bf7\u6ce8\u610f:==\n\u5c06XML\u683c\u5f0f\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3aXML DOM\u5bf9\u8c61\u65f6\u53d1\u751f\u9519\u8bef\u5566!\n\u8be6\u7ec6\u9519\u8bef\u4fe1\u606f\u5982\u4e0b:", (Throwable)e);
        }
        Element elRoot = document.getRootElement();
        Iterator elIt = elRoot.elementIterator();
        while (elIt.hasNext()) {
            Element el = (Element)elIt.next();
            Iterator attrIt = el.attributeIterator();
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (attrIt.hasNext()) {
                Attribute attribute = (Attribute)attrIt.next();
                map.put(attribute.getName().toLowerCase(), attribute.getData());
            }
            lst.add(map);
        }
        return lst;
    }

    public static Map<String, Object> dom2Map(Document doc) {
        HashMap<String, Object> maproot = new HashMap<String, Object>();
        if (doc == null) {
            return maproot;
        }
        Element root = doc.getRootElement();
        List list1 = root.elements();
        for (Object obj : list1) {
            Element element = (Element)obj;
            HashMap<String, Object> map = new HashMap<String, Object>();
            XmlUtil.element2Map(element, map);
            maproot.put(element.getName(), map);
        }
        return maproot;
    }

    public static void element2Map(Element e, Map<String, Object> map) {
        List list = e.elements();
        if (e.attributeCount() > 0) {
            for (Object attri : e.attributes()) {
                Attribute at = (Attribute)attri;
                map.put(at.getName(), at.getValue());
            }
        }
        if (list.size() < 1 && DataUtil.isEmpty(e.getText())) {
            return;
        }
        if (list.size() < 1 && !DataUtil.isEmpty(e.getText())) {
            map.put("text", e.getText());
        }
        for (Object aList : list) {
            Element iter = (Element)aList;
            HashMap<String, Object> cMap = new HashMap<String, Object>();
            XmlUtil.element2Map(iter, cMap);
            map.put(iter.getName(), cMap);
        }
    }

    public static Map MqResToDto(String recv) {
        ArrayList<Map> res = new ArrayList<Map>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Document doc = DocumentHelper.parseText((String)recv);
            List list = doc.selectNodes("//item");
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Map elementdto = XmlUtil.Dom2Map((Element)it.next());
                res.add(elementdto);
            }
            map.put("resultList", res);
            Node de = doc.selectSingleNode("//REC_MNT");
            if (DataUtil.isNotEmpty(de)) {
                map.put("countInteger", de.getText());
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return map;
    }
}

