/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.web.util.WebUtils;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.Request2ListUtil;
import top.ibase4j.core.util.Request2ModelUtil;
import top.ibase4j.core.util.XmlUtil;

public final class WebUtil {
    private static Logger logger = LogManager.getLogger();

    private WebUtil() {
    }

    public static final String getCookieValue(HttpServletRequest request, String cookieName, String defaultValue) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)cookieName);
        if (cookie == null) {
            return defaultValue;
        }
        return cookie.getValue();
    }

    public static final void saveCurrentUser(Object user) {
        WebUtil.setSession("CURRENT_USER", user);
    }

    public static final void saveCurrentUser(HttpServletRequest request, Object user) {
        WebUtil.setSession(request, "CURRENT_USER", user);
    }

    public static final Long getCurrentUser() {
        Subject currentUser = SecurityUtils.getSubject();
        if (null != currentUser) {
            try {
                Session session = currentUser.getSession();
                if (null != session) {
                    return (Long)session.getAttribute((Object)"CURRENT_USER");
                }
            }
            catch (InvalidSessionException e) {
                logger.error("", (Throwable)e);
            }
        }
        return null;
    }

    public static final Object getCurrentUser(HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            if (null != session) {
                return session.getAttribute("CURRENT_USER");
            }
        }
        catch (InvalidSessionException e) {
            logger.error("", (Throwable)e);
        }
        return null;
    }

    public static final void setSession(Object key, Object value) {
        Session session;
        Subject currentUser = SecurityUtils.getSubject();
        if (null != currentUser && null != (session = currentUser.getSession())) {
            session.setAttribute(key, value);
        }
    }

    public static final void setSession(HttpServletRequest request, String key, Object value) {
        HttpSession session = request.getSession();
        if (null != session) {
            session.setAttribute(key, value);
        }
    }

    public static final void removeCurrentUser(HttpServletRequest request) {
        request.getSession().removeAttribute("CURRENT_USER");
    }

    public static final String getApplicationResource(String key, HttpServletRequest request) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ApplicationResources", request.getLocale());
        return resourceBundle.getString(key);
    }

    public static final Map<String, Object> getParameterMap(HttpServletRequest request) {
        return WebUtils.getParametersStartingWith((ServletRequest)request, null);
    }

    public static Map<String, Object> getParameter(HttpServletRequest request) {
        String wholeStr = "";
        try {
            String str;
            BufferedReader br = request.getReader();
            while ((str = br.readLine()) != null) {
                wholeStr = wholeStr + str;
            }
            if (StringUtils.isNotBlank((CharSequence)wholeStr)) {
                logger.info("request===>" + wholeStr);
                request.setAttribute("iBase4J.Parameters", (Object)wholeStr);
                try {
                    return (Map)JSON.parseObject((String)wholeStr, Map.class);
                }
                catch (Exception e) {
                    return XmlUtil.parseXml2Map(wholeStr);
                }
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        logger.info("request===>" + JSON.toJSONString((Object)request.getParameterMap()));
        return WebUtil.getParameterMap(request);
    }

    public static <T> T getParameter(HttpServletRequest request, Class<T> cls) {
        String wholeStr = "";
        try {
            String str;
            BufferedReader br = request.getReader();
            while ((str = br.readLine()) != null) {
                wholeStr = wholeStr + str;
            }
            if (StringUtils.isNotBlank((CharSequence)wholeStr)) {
                logger.info("request===>" + wholeStr);
                request.setAttribute("iBase4J.Parameters", (Object)wholeStr);
                try {
                    return (T)JSON.parseObject((String)wholeStr, cls);
                }
                catch (Exception e) {
                    return InstanceUtil.parse(wholeStr, cls);
                }
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        logger.info("request===>" + JSON.toJSONString((Object)request.getParameterMap()));
        return Request2ModelUtil.covert(cls, request);
    }

    public static <T> List<T> getParameters(HttpServletRequest request, Class<T> cls) {
        String wholeStr = "";
        try {
            String str;
            BufferedReader br = request.getReader();
            while ((str = br.readLine()) != null) {
                wholeStr = wholeStr + str;
            }
            if (StringUtils.isNotBlank((CharSequence)wholeStr)) {
                logger.info("request===>" + wholeStr);
                List list = (List)JSON.parseObject((String)wholeStr, List.class);
                ArrayList<T> resultList = InstanceUtil.newArrayList();
                for (Object map : list) {
                    T t = InstanceUtil.transMap2Bean((Map)map, cls);
                    resultList.add(t);
                }
                request.setAttribute("iBase4J.Parameters", resultList);
                return resultList;
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        logger.info("request===>" + JSON.toJSONString((Object)request.getParameterMap()));
        return Request2ListUtil.covert(cls, request);
    }

    public static final String getHost(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.indexOf(",") > 0) {
            logger.info(ip);
            String[] ips = ip.split(",");
            for (int index = 0; index < ips.length; ++index) {
                String strIp = ips[index];
                if ("unknown".equalsIgnoreCase(strIp)) continue;
                ip = strIp;
                break;
            }
        }
        if ("127.0.0.1".equals(ip) || "0:0:0:0:0:0:0:1".equals(ip)) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                logger.error("getCurrentIP", (Throwable)e);
            }
            if (inet != null) {
                ip = inet.getHostAddress();
            }
        }
        logger.info("getRemoteAddr ip: " + ip);
        return ip;
    }

    public static void setResponseFileName(HttpServletRequest request, HttpServletResponse response, String displayName) {
        String userAgent = request.getHeader("User-Agent");
        boolean isIE = false;
        if (userAgent != null && userAgent.toLowerCase().contains("msie")) {
            isIE = true;
        }
        try {
            String displayName2;
            if (isIE) {
                displayName2 = URLEncoder.encode(displayName, "UTF-8");
                displayName2 = displayName2.replaceAll("\\+", "%20");
                response.setHeader("Content-Disposition", "attachment;filename=" + displayName2);
            } else {
                displayName2 = new String(displayName.getBytes("UTF-8"), "ISO8859-1");
                response.setHeader("Content-Disposition", "attachment;filename=\"" + displayName2 + "\"");
            }
            String extStr = displayName2.substring(displayName2.indexOf(".") + 1);
            if ("xls".equalsIgnoreCase(extStr)) {
                response.setContentType("application/vnd.ms-excel charset=UTF-8");
            } else {
                response.setContentType("application/octet-stream");
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u8bbe\u7f6e\u6587\u4ef6\u540d\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }
}

