/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SerializeUtil {
    private static final Logger logger = LogManager.getLogger();

    private SerializeUtil() {
    }

    public static final byte[] serialize(Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    public static final Object deserialize(byte[] bytes) {
        return SerializeUtil.deserialize(bytes, Object.class);
    }

    public static final <K> K deserialize(byte[] bytes, Class<K> cls) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return (K)object;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            try {
                if (bais != null) {
                    bais.close();
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }
}

