/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.jedis;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.BinaryJedisCluster;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterCommand;
import top.ibase4j.core.support.cache.ICacheManager;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;

public class JedisClusterTemplate
extends BinaryJedisCluster
implements ICacheManager {
    private Integer EXPIRE = PropertiesUtil.getInt("redis.expiration");

    public JedisClusterTemplate(Set<HostAndPort> jedisClusterNode, int timeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, timeout, maxAttempts, poolConfig);
    }

    public JedisClusterTemplate(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, poolConfig);
    }

    public JedisClusterTemplate(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, String password, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, password, poolConfig);
    }

    public JedisClusterTemplate(Set<HostAndPort> nodes, int timeout) {
        super(nodes, timeout);
    }

    public JedisClusterTemplate(Set<HostAndPort> nodes) {
        super(nodes);
    }

    public <K> K run(final String key, final Executor<K> executor, final Integer ... expire) {
        return (K)new JedisClusterCommand<K>(this.connectionHandler, this.maxAttempts){

            public K execute(Jedis jedis) {
                Object result = executor.execute(jedis);
                if (jedis.exists(key).booleanValue()) {
                    if (expire == null || expire.length == 0) {
                        jedis.expire(key, JedisClusterTemplate.this.EXPIRE.intValue());
                    } else if (expire.length == 1) {
                        jedis.expire(key, expire[0].intValue());
                    }
                }
                return result;
            }
        }.run(key);
    }

    @Override
    public final Object get(final String key) {
        return this.run(key, new Executor<Object>(){

            @Override
            public Object execute(Jedis jedis) {
                return JSON.parse((String)jedis.get(key));
            }
        }, new Integer[0]);
    }

    @Override
    public final Object get(final String key, Integer expire) {
        return this.run(key, new Executor<Object>(){

            @Override
            public Object execute(Jedis jedis) {
                return JSON.parse((String)jedis.get(key));
            }
        }, expire);
    }

    @Override
    public void set(final String key, final Serializable value) {
        this.run(key, new Executor<String>(){

            @Override
            public String execute(Jedis jedis) {
                return jedis.set(key, JSON.toJSONString((Object)value));
            }
        }, new Integer[0]);
    }

    @Override
    public final void set(final String key, final Serializable value, final int seconds) {
        this.run(key, new Executor<String>(){

            @Override
            public String execute(Jedis jedis) {
                return jedis.setex(key, seconds, JSON.toJSONString((Object)value));
            }
        }, seconds, seconds);
    }

    @Override
    public final Boolean exists(final String key) {
        return this.run(key, new Executor<Boolean>(){

            @Override
            public Boolean execute(Jedis jedis) {
                return jedis.exists(key);
            }
        }, new Integer[0]);
    }

    @Override
    public final void del(final String key) {
        this.run(key, new Executor<Long>(){

            @Override
            public Long execute(Jedis jedis) {
                return jedis.del(key);
            }
        }, new Integer[0]);
    }

    @Override
    public final String type(final String key) {
        return this.run(key, new Executor<String>(){

            @Override
            public String execute(Jedis jedis) {
                return jedis.type(key);
            }
        }, new Integer[0]);
    }

    @Override
    public final Boolean expire(final String key, final int seconds) {
        return this.run(key, new Executor<Long>(){

            @Override
            public Long execute(Jedis jedis) {
                return jedis.expire(key, seconds);
            }
        }, seconds, seconds) == 1L;
    }

    @Override
    public final Boolean expireAt(final String key, final long unixTime) {
        return this.run(key, new Executor<Long>(){

            @Override
            public Long execute(Jedis jedis) {
                return jedis.expireAt(key, unixTime);
            }
        }, new Integer[0]) == 1L;
    }

    @Override
    public final Long ttl(final String key) {
        return this.run(key, new Executor<Long>(){

            @Override
            public Long execute(Jedis jedis) {
                return jedis.ttl(key);
            }
        }, new Integer[0]);
    }

    @Override
    public final void setrange(final String key, final long offset, final String value) {
        this.run(key, new Executor<Long>(){

            @Override
            public Long execute(Jedis jedis) {
                return jedis.setrange(key, offset, value);
            }
        }, new Integer[0]);
    }

    @Override
    public final String getrange(final String key, final long startOffset, final long endOffset) {
        return this.run(key, new Executor<String>(){

            @Override
            public String execute(Jedis jedis) {
                return jedis.getrange(key, startOffset, endOffset);
            }
        }, new Integer[0]);
    }

    @Override
    public final Object getSet(final String key, final Serializable value) {
        return this.run(key, new Executor<Object>(){

            @Override
            public Object execute(Jedis jedis) {
                return JSON.parse((String)jedis.getSet(key, JSON.toJSONString((Object)value)));
            }
        }, new Integer[0]);
    }

    @Override
    public final Long incr(final String key) {
        return this.run(key, new Executor<Long>(){

            @Override
            public Long execute(Jedis jedis) {
                return jedis.incr(key);
            }
        }, new Integer[0]);
    }

    @Override
    public final void hset(final String key, final Serializable field, final Serializable value) {
        this.run(key, new Executor<Object>(){

            @Override
            public Object execute(Jedis jedis) {
                return jedis.hset(key, JSON.toJSONString((Object)field), JSON.toJSONString((Object)value));
            }
        }, new Integer[0]);
    }

    @Override
    public final Object hget(final String key, final Serializable field) {
        return this.run(key, new Executor<Object>(){

            @Override
            public Object execute(Jedis jedis) {
                return JSON.parse((String)jedis.hget(key, JSON.toJSONString((Object)field)));
            }
        }, new Integer[0]);
    }

    @Override
    public final void hdel(final String key, final Serializable field) {
        this.run(key, new Executor<Long>(){

            @Override
            public Long execute(Jedis jedis) {
                return jedis.hdel(key, new String[]{JSON.toJSONString((Object)field)});
            }
        }, new Integer[0]);
    }

    @Override
    public Set<Object> getAll(final String pattern) {
        return this.run(pattern, new Executor<Set<Object>>(){

            @Override
            public Set<Object> execute(Jedis jedis) {
                Set keys = jedis.hkeys(pattern);
                HashSet<Object> set = InstanceUtil.newHashSet();
                for (String key : keys) {
                    set.add(JSON.parse((String)jedis.get(key)));
                }
                return set;
            }
        }, new Integer[0]);
    }

    @Override
    public void delAll(final String pattern) {
        this.run(pattern, new Executor<Object>(){

            @Override
            public Object execute(Jedis jedis) {
                Set keys = jedis.hkeys(pattern);
                for (String key : keys) {
                    jedis.del(key);
                }
                return true;
            }
        }, new Integer[0]);
    }

    @Override
    public boolean setnx(final String key, final Serializable value) {
        return this.run(key, new Executor<Long>(){

            @Override
            public Long execute(Jedis jedis) {
                return jedis.setnx(key, JSON.toJSONString((Object)value));
            }
        }, new Integer[0]) == 1L;
    }

    @Override
    public void unlock(String key) {
        this.del(key);
    }

    public boolean getLock(final String key) {
        return this.run(key, new Executor<Long>(){

            @Override
            public Long execute(Jedis jedis) {
                return jedis.setnx(key, "0");
            }
        }, new Integer[0]) == 1L;
    }

    @Override
    public boolean lock(final String key) {
        return this.run(key, new Executor<Long>(){

            @Override
            public Long execute(Jedis jedis) {
                return jedis.setnx(key, "0");
            }
        }, new Integer[0]) == 1L;
    }

    @Override
    public Object getFire(String key) {
        this.expireAt(key, this.EXPIRE.intValue());
        return this.get(key);
    }

    @Override
    public Set<Object> getAll(final String pattern, final Integer expire) {
        return this.run(pattern, new Executor<Set<Object>>(){

            @Override
            public Set<Object> execute(Jedis jedis) {
                Set keys = jedis.hkeys(pattern);
                HashSet<Object> set = InstanceUtil.newHashSet();
                for (String key : keys) {
                    set.add(JSON.parse((String)jedis.get(key)));
                    jedis.expire(key, expire.intValue());
                }
                return set;
            }
        }, new Integer[0]);
    }

    static interface Executor<K> {
        public K execute(Jedis var1);
    }
}

