/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.jedis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.InitializingBean;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisShardInfo;
import top.ibase4j.core.support.cache.ICacheManager;
import top.ibase4j.core.support.jedis.JedisClusterTemplate;
import top.ibase4j.core.support.jedis.JedisSentinelTemplate;
import top.ibase4j.core.support.jedis.JedisShardedTemplate;
import top.ibase4j.core.support.jedis.JedisTemplate;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.InstanceUtil;

public class ConnectionFactory
implements InitializingBean,
ICacheManager {
    private GenericObjectPoolConfig poolConfig;
    private String clusterAddress;
    private String shardedAddress;
    private int maxRedirects = 5;
    private String host;
    private int port;
    private String password;
    private String master;
    private String sentinels;
    private ICacheManager cacheManager;
    private int connectTimeout = 2000;
    private int readTimeout = 2000;

    public ConnectionFactory() {
    }

    public ConnectionFactory(GenericObjectPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    public ConnectionFactory(GenericObjectPoolConfig poolConfig, String shardedAddress) {
        this.poolConfig = poolConfig;
        this.shardedAddress = shardedAddress;
    }

    public ConnectionFactory(GenericObjectPoolConfig poolConfig, String master, String sentinels) {
        this.poolConfig = poolConfig;
        this.master = master;
        this.sentinels = sentinels;
    }

    public ConnectionFactory(GenericObjectPoolConfig poolConfig, String clusterAddress, int maxRedirects) {
        this.poolConfig = poolConfig;
        this.clusterAddress = clusterAddress;
        this.maxRedirects = maxRedirects;
    }

    public ConnectionFactory(GenericObjectPoolConfig poolConfig, String host, int port, String password) {
        this.poolConfig = poolConfig;
        this.host = host;
        this.port = port;
        if (DataUtil.isNotEmpty(password)) {
            this.password = password;
        }
    }

    public void setPoolConfig(GenericObjectPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    public void setClusterAddress(String clusterAddress) {
        this.clusterAddress = clusterAddress;
    }

    public void setShardedAddress(String shardedAddress) {
        this.shardedAddress = shardedAddress;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPassword(String password) {
        if (DataUtil.isNotEmpty(password)) {
            this.password = password;
        }
    }

    public void setMaster(String master) {
        this.master = master;
    }

    public void setSentinels(String sentinels) {
        this.sentinels = sentinels;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.poolConfig == null) {
            throw new RuntimeException("\u7ebf\u7a0b\u6c60\u914d\u7f6e\u9519\u8bef");
        }
        if (DataUtil.isNotEmpty(this.shardedAddress)) {
            String[] hostPorts;
            ArrayList<JedisShardInfo> shards = InstanceUtil.newArrayList();
            for (String hostPort : hostPorts = this.shardedAddress.split(",")) {
                String[] hostAndPort = hostPort.split(":");
                if (hostAndPort.length != 2 || !StringUtils.isNumeric((CharSequence)hostAndPort[1])) {
                    throw new RuntimeException("\u5c5e\u6027\u914d\u7f6e\u9519\u8bef");
                }
                JedisShardInfo shardInfo = new JedisShardInfo(hostAndPort[0], Integer.valueOf(hostAndPort[1]).intValue(), this.connectTimeout);
                shardInfo.setPassword(this.password);
                shards.add(shardInfo);
            }
            this.cacheManager = new JedisShardedTemplate(this.poolConfig, shards);
        } else if (DataUtil.isNotEmpty(this.clusterAddress)) {
            String[] addrs = this.clusterAddress.split(",");
            HashSet<HostAndPort> jedisClusterNodes = InstanceUtil.newHashSet();
            for (String addr : addrs) {
                jedisClusterNodes.add(HostAndPort.parseString((String)addr));
            }
            this.cacheManager = new JedisClusterTemplate(jedisClusterNodes, this.connectTimeout, this.readTimeout, this.maxRedirects, this.password, this.poolConfig);
        } else if (DataUtil.isNotEmpty(this.master) && DataUtil.isNotEmpty(this.sentinels)) {
            Set<String> set = InstanceUtil.newHashSet(this.sentinels.split(","));
            this.cacheManager = new JedisSentinelTemplate(this.master, set, this.poolConfig, this.connectTimeout, this.password);
        } else if (DataUtil.isNotEmpty(this.host) && DataUtil.isNotEmpty(this.host)) {
            this.cacheManager = new JedisTemplate(this.poolConfig, this.host, this.port, this.connectTimeout, this.password);
        } else {
            throw new RuntimeException("redis\u8fde\u63a5\u914d\u7f6e\u9519\u8bef");
        }
    }

    @Override
    public Object get(String key) {
        return this.cacheManager.get(key);
    }

    @Override
    public Set<Object> getAll(String pattern) {
        return this.cacheManager.getAll(pattern);
    }

    @Override
    public void set(String key, Serializable value, int seconds) {
        this.cacheManager.set(key, value, seconds);
    }

    @Override
    public void set(String key, Serializable value) {
        this.cacheManager.set(key, value);
    }

    @Override
    public Boolean exists(String key) {
        return this.cacheManager.exists(key);
    }

    @Override
    public void del(String key) {
        this.cacheManager.del(key);
    }

    @Override
    public void delAll(String pattern) {
        this.cacheManager.delAll(pattern);
    }

    @Override
    public String type(String key) {
        return this.cacheManager.type(key);
    }

    @Override
    public Boolean expire(String key, int seconds) {
        return this.cacheManager.expire(key, seconds);
    }

    @Override
    public Boolean expireAt(String key, long unixTime) {
        return this.cacheManager.expireAt(key, unixTime);
    }

    @Override
    public Long ttl(String key) {
        return this.cacheManager.ttl(key);
    }

    @Override
    public Object getSet(String key, Serializable value) {
        return this.cacheManager.getSet(key, value);
    }

    @Override
    public boolean lock(String key) {
        return this.cacheManager.lock(key);
    }

    @Override
    public void unlock(String key) {
        this.cacheManager.unlock(key);
    }

    @Override
    public void hset(String key, Serializable field, Serializable value) {
        this.cacheManager.hset(key, field, value);
    }

    @Override
    public Object hget(String key, Serializable field) {
        return this.cacheManager.hget(key, field);
    }

    @Override
    public void hdel(String key, Serializable field) {
        this.cacheManager.hdel(key, field);
    }

    @Override
    public boolean setnx(String key, Serializable value) {
        return this.cacheManager.setnx(key, value);
    }

    @Override
    public Long incr(String key) {
        return this.cacheManager.incr(key);
    }

    @Override
    public void setrange(String key, long offset, String value) {
        this.cacheManager.setrange(key, offset, value);
    }

    @Override
    public String getrange(String key, long startOffset, long endOffset) {
        return this.cacheManager.getrange(key, startOffset, endOffset);
    }

    @Override
    public Object get(String key, Integer expire) {
        return this.cacheManager.get(key, expire);
    }

    @Override
    public Object getFire(String key) {
        return this.cacheManager.getFire(key);
    }

    @Override
    public Set<Object> getAll(String pattern, Integer expire) {
        return this.cacheManager.getAll(pattern, expire);
    }
}

