/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.email;

import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.config.Resources;
import top.ibase4j.core.util.PropertiesUtil;

public final class EmailSender {
    private final Logger logger = LogManager.getLogger();
    private MimeMessage mimeMsg;
    private Session session;
    private Properties props;
    private String username = "";
    private String password = "";
    private String userkey = "";
    private Multipart mp;

    public EmailSender(String smtp) {
        try {
            this.setSmtpHost(smtp);
            this.createMimeMessage();
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
    }

    public void setSmtpHost(String hostName) {
        if (hostName == null || hostName.trim().equals("")) {
            hostName = PropertiesUtil.getString("email.smtp.host");
        }
        this.logger.info(Resources.getMessage("EMAIL.SET_HOST", new Object[0]), (Object)hostName);
        if (this.props == null) {
            this.props = System.getProperties();
        }
        this.props.put("mail.smtp.host", hostName);
    }

    public boolean createMimeMessage() {
        try {
            this.session = Session.getDefaultInstance((Properties)this.props, null);
        }
        catch (Exception e) {
            this.logger.error(Resources.getMessage("EMAIL.ERROR_TALK", new Object[0]), (Object)e.getLocalizedMessage());
            return false;
        }
        try {
            this.mimeMsg = new MimeMessage(this.session);
            this.mp = new MimeMultipart();
            return true;
        }
        catch (Exception e) {
            this.logger.error(Resources.getMessage("EMAIL.ERROR_MIME", new Object[0]), (Object)e.getLocalizedMessage());
            return false;
        }
    }

    private void setNeedAuth() {
        if (this.props == null) {
            this.props = System.getProperties();
        }
        if (this.userkey == null || this.userkey.trim().equals("")) {
            this.userkey = PropertiesUtil.getString("email.authorisation.code");
        }
        if (this.userkey == null || this.userkey.trim().equals("")) {
            this.props.put("mail.smtp.auth", "false");
            this.logger.info(Resources.getMessage("EMAIL.SET_AUTH", new Object[0]), (Object)"false");
        } else {
            this.props.put("mail.smtp.auth", "true");
            this.logger.info(Resources.getMessage("EMAIL.SET_AUTH", new Object[0]), (Object)"true");
        }
    }

    public void setNamePass(String name, String pass, String key) {
        if (name == null || name.trim().equals("")) {
            name = PropertiesUtil.getString("email.user.name");
        }
        if (pass == null || pass.trim().equals("")) {
            pass = PropertiesUtil.getString("email.user.password");
        }
        this.username = name;
        this.password = pass;
        this.userkey = key;
        this.setNeedAuth();
    }

    public boolean setSubject(String mailSubject) {
        this.logger.info(Resources.getMessage("EMAIL.SET_SUBJECT", new Object[0]), (Object)mailSubject);
        try {
            this.mimeMsg.setSubject(mailSubject, "UTF-8");
            return true;
        }
        catch (Exception e) {
            this.logger.error(Resources.getMessage("EMAIL.ERROR_SUBJECT", new Object[0]), (Throwable)e);
            return false;
        }
    }

    public boolean setBody(String mailBody) {
        try {
            MimeBodyPart bp = new MimeBodyPart();
            bp.setContent((Object)("" + mailBody), "text/html;charset=UTF-8");
            this.mp.addBodyPart((BodyPart)bp);
            return true;
        }
        catch (Exception e) {
            this.logger.error(Resources.getMessage("EMAIL.ERROR_BODY", new Object[0]), (Throwable)e);
            return false;
        }
    }

    public boolean addFileAffix(String filename) {
        this.logger.info(Resources.getMessage("EMAIL.ADD_ATTEND", new Object[0]), (Object)filename);
        try {
            MimeBodyPart bp = new MimeBodyPart();
            FileDataSource fileds = new FileDataSource(filename);
            bp.setDataHandler(new DataHandler((DataSource)fileds));
            bp.setFileName(MimeUtility.encodeText((String)fileds.getName()));
            this.mp.addBodyPart((BodyPart)bp);
            return true;
        }
        catch (Exception e) {
            this.logger.error(filename, (Throwable)e);
            return false;
        }
    }

    public boolean setFrom(String from) {
        if (from == null || from.trim().equals("")) {
            from = PropertiesUtil.getString("email.send.from");
        }
        try {
            String[] f = from.split(",");
            if (f.length > 1) {
                from = MimeUtility.encodeText((String)f[0]) + "<" + f[1] + ">";
            }
            this.mimeMsg.setFrom((Address)new InternetAddress(from));
            return true;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean setTo(String to) {
        if (to == null) {
            return false;
        }
        this.logger.info(Resources.getMessage("EMAIL.SET_TO", new Object[0]), (Object)to);
        try {
            this.mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            return true;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean setCopyTo(String copyto) {
        if (copyto == null) {
            return false;
        }
        this.logger.info(Resources.getMessage("EMAIL.SET_COPYTO", new Object[0]), (Object)copyto);
        try {
            this.mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)copyto));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean sendout() {
        try {
            this.mimeMsg.setContent(this.mp);
            this.mimeMsg.saveChanges();
            this.logger.info(Resources.getMessage("EMAIL.SENDING", new Object[0]));
            Session mailSession = Session.getInstance((Properties)this.props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    if (EmailSender.this.userkey == null || "".equals(EmailSender.this.userkey.trim())) {
                        return null;
                    }
                    return new PasswordAuthentication(EmailSender.this.username, EmailSender.this.userkey);
                }
            });
            Transport transport = mailSession.getTransport("smtp");
            transport.connect((String)this.props.get("mail.smtp.host"), this.username, this.password);
            this.mimeMsg.setSentDate(new Date());
            transport.sendMessage((Message)this.mimeMsg, this.mimeMsg.getRecipients(Message.RecipientType.TO));
            if (this.mimeMsg.getRecipients(Message.RecipientType.CC) != null) {
                transport.sendMessage((Message)this.mimeMsg, this.mimeMsg.getRecipients(Message.RecipientType.CC));
            }
            this.logger.info(Resources.getMessage("EMAIL.SEND_SUCC", new Object[0]));
            transport.close();
            return true;
        }
        catch (Exception e) {
            this.logger.error(Resources.getMessage("EMAIL.SEND_ERR", new Object[0]), (Throwable)e);
            return false;
        }
    }
}

