/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.dbcp;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import top.ibase4j.core.support.dbcp.ChooseDataSource;
import top.ibase4j.core.support.dbcp.HandleDataSource;

@Aspect
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class DataSourceAspect {
    private final Logger logger = LogManager.getLogger();

    @Pointcut(value="execution(* top.ibase4j.core.base.IBaseService.*(..))")
    public void aspect() {
    }

    @Before(value="aspect()")
    public void before(JoinPoint point) {
        block5: {
            if (HandleDataSource.getDataSource() == null) {
                String method = point.getSignature().getName();
                try {
                    for (String key : ChooseDataSource.METHODTYPE.keySet()) {
                        for (String type : ChooseDataSource.METHODTYPE.get(key)) {
                            if (!method.startsWith(type)) continue;
                            this.logger.info(key);
                            HandleDataSource.putDataSource(key);
                            break block5;
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("", (Throwable)e);
                    HandleDataSource.putDataSource("write");
                }
            }
        }
    }

    static {
        System.setProperty("druid.logType", "log4j2");
    }
}

