/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import top.ibase4j.core.support.cache.ICacheManager;
import top.ibase4j.core.util.CacheUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;

public final class RedisHelper
implements ICacheManager {
    private RedisSerializer<String> keySerializer;
    private RedisSerializer<Object> valueSerializer;
    private RedisTemplate<Serializable, Serializable> redisTemplate;
    private final Integer EXPIRE = PropertiesUtil.getInt("redis.expiration");

    public void setRedisTemplate(RedisTemplate<Serializable, Serializable> redisTemplate) {
        this.redisTemplate = redisTemplate;
        this.keySerializer = redisTemplate.getKeySerializer();
        this.valueSerializer = redisTemplate.getValueSerializer();
        CacheUtil.setCacheManager(this);
    }

    public RedisTemplate<Serializable, Serializable> getRedisTemplate() {
        return this.redisTemplate;
    }

    @Override
    public final Object get(String key) {
        return this.redisTemplate.boundValueOps((Object)key).get();
    }

    @Override
    public final Object get(String key, Integer expire) {
        this.expire(key, expire);
        return this.redisTemplate.boundValueOps((Object)key).get();
    }

    @Override
    public final Object getFire(String key) {
        this.expire(key, this.EXPIRE);
        return this.redisTemplate.boundValueOps((Object)key).get();
    }

    @Override
    public final Set<Object> getAll(String pattern) {
        HashSet<Object> values = InstanceUtil.newHashSet();
        Set keys = this.redisTemplate.keys((Object)pattern);
        for (Serializable key : keys) {
            values.add(this.redisTemplate.opsForValue().get((Object)key));
        }
        return values;
    }

    @Override
    public final Set<Object> getAll(String pattern, Integer expire) {
        HashSet<Object> values = InstanceUtil.newHashSet();
        Set keys = this.redisTemplate.keys((Object)pattern);
        for (Serializable key : keys) {
            this.expire(key.toString(), expire);
            values.add(this.redisTemplate.opsForValue().get((Object)key));
        }
        return values;
    }

    @Override
    public final void set(String key, Serializable value, int seconds) {
        this.redisTemplate.boundValueOps((Object)key).set((Object)value);
        this.expire(key, seconds);
    }

    @Override
    public final void set(String key, Serializable value) {
        this.redisTemplate.boundValueOps((Object)key).set((Object)value);
        this.expire(key, this.EXPIRE);
    }

    @Override
    public final Boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    @Override
    public final void del(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public final void delAll(String pattern) {
        this.redisTemplate.delete((Collection)this.redisTemplate.keys((Object)pattern));
    }

    @Override
    public final String type(String key) {
        return this.redisTemplate.type((Object)key).getClass().getName();
    }

    @Override
    public final Boolean expire(String key, int seconds) {
        return this.redisTemplate.expire((Object)key, (long)seconds, TimeUnit.SECONDS);
    }

    @Override
    public final Boolean expireAt(String key, long unixTime) {
        return this.redisTemplate.expireAt((Object)key, new Date(unixTime));
    }

    @Override
    public final Long ttl(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    @Override
    public final void setrange(String key, long offset, String value) {
        this.redisTemplate.boundValueOps((Object)key).set((Object)value, offset);
    }

    @Override
    public final String getrange(String key, long startOffset, long endOffset) {
        return this.redisTemplate.boundValueOps((Object)key).get(startOffset, endOffset);
    }

    @Override
    public final Object getSet(String key, Serializable value) {
        return this.redisTemplate.boundValueOps((Object)key).getAndSet((Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setnx(String key, Serializable value) {
        RedisConnectionFactory factory = this.redisTemplate.getConnectionFactory();
        RedisConnection redisConnection = null;
        try {
            redisConnection = RedisConnectionUtils.getConnection((RedisConnectionFactory)factory);
            if (redisConnection == null) {
                boolean bl = this.redisTemplate.boundValueOps((Object)key).setIfAbsent((Object)value);
                return bl;
            }
            boolean bl = redisConnection.setNX(this.keySerializer.serialize((Object)key), this.valueSerializer.serialize((Object)value));
            return bl;
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(String key) {
        RedisConnectionFactory factory = this.redisTemplate.getConnectionFactory();
        RedisConnection redisConnection = null;
        try {
            redisConnection = RedisConnectionUtils.getConnection((RedisConnectionFactory)factory);
            if (redisConnection == null) {
                boolean bl = this.redisTemplate.boundValueOps((Object)key).setIfAbsent((Object)"0");
                return bl;
            }
            boolean bl = redisConnection.setNX(this.keySerializer.serialize((Object)key), this.valueSerializer.serialize((Object)"0"));
            return bl;
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)factory);
        }
    }

    @Override
    public void unlock(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public void hset(String key, Serializable field, Serializable value) {
        this.redisTemplate.boundHashOps((Object)key).put((Object)field, (Object)value);
    }

    @Override
    public Object hget(String key, Serializable field) {
        return this.redisTemplate.boundHashOps((Object)key).get((Object)field);
    }

    @Override
    public void hdel(String key, Serializable field) {
        this.redisTemplate.boundHashOps((Object)key).delete(new Object[]{field});
    }

    @Override
    public Long incr(String key) {
        return this.redisTemplate.boundValueOps((Object)key).increment(1L);
    }
}

