/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;
import top.ibase4j.core.interceptor.BaseInterceptor;
import top.ibase4j.core.support.HttpCode;
import top.ibase4j.core.util.CacheUtil;
import top.ibase4j.core.util.FileUtil;
import top.ibase4j.core.util.WebUtil;

public class MaliciousRequestInterceptor
extends BaseInterceptor {
    private boolean allRequest = false;
    private boolean containsParamter = true;
    private int minRequestIntervalTime = 500;
    private int maxMaliciousTimes = 0;
    private List<String> whiteUrls;
    private int _size = 0;

    public MaliciousRequestInterceptor() {
        String path = MaliciousRequestInterceptor.class.getResource("/").getFile();
        this.whiteUrls = FileUtil.readFile(path + "white/mrqWhite.txt");
        this._size = null == this.whiteUrls ? 0 : this.whiteUrls.size();
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Object userId;
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "POST,GET,PUT,OPTIONS,DELETE");
        response.setHeader("Access-Control-Allow-Headers", "x-requested-with,Access-Control-Allow-Origin,EX-SysAuthToken,EX-JSESSIONID");
        String url = request.getServletPath();
        if (url.endsWith("/unauthorized") || url.endsWith("/forbidden") || this.isWhiteReq(url.toLowerCase())) {
            return super.preHandle(request, response, handler);
        }
        if (this.containsParamter) {
            url = url + JSON.toJSONString(WebUtil.getParameterMap(request));
        }
        String user = (userId = WebUtil.getCurrentUser(request)) != null ? userId.toString() : WebUtil.getHost(request) + request.getHeader("USER-AGENT");
        String preRequest = (String)CacheUtil.getCache().getFire("iBase4J:PREREQUEST" + user);
        Long preRequestTime = (Long)CacheUtil.getCache().getFire("iBase4J:PREREQUEST_TIME" + user);
        int seconds = this.minRequestIntervalTime;
        if (preRequestTime != null && preRequest != null) {
            if ((url.equals(preRequest) || this.allRequest) && System.currentTimeMillis() - preRequestTime < (long)this.minRequestIntervalTime) {
                Integer maliciousRequestTimes = (Integer)CacheUtil.getCache().getFire("iBase4J:MALICIOUS_REQUEST_TIMES" + user);
                if (maliciousRequestTimes == null) {
                    maliciousRequestTimes = 1;
                } else {
                    Integer n = maliciousRequestTimes;
                    Integer n2 = maliciousRequestTimes = Integer.valueOf(maliciousRequestTimes + 1);
                }
                CacheUtil.getCache().set("iBase4J:MALICIOUS_REQUEST_TIMES" + user, maliciousRequestTimes, seconds);
                if (maliciousRequestTimes > this.maxMaliciousTimes) {
                    CacheUtil.getCache().set("iBase4J:MALICIOUS_REQUEST_TIMES" + user, Integer.valueOf(0), seconds);
                    logger.warn("To intercept a malicious request : {}", (Object)url);
                    ModelMap modelMap = new ModelMap();
                    modelMap.put((Object)"code", (Object)HttpCode.MULTI_STATUS.value().toString());
                    modelMap.put((Object)"msg", (Object)HttpCode.MULTI_STATUS.msg());
                    modelMap.put((Object)"timestamp", (Object)System.currentTimeMillis());
                    logger.info("RESPONSE : " + JSON.toJSON((Object)modelMap));
                    byte[] bytes = JSON.toJSONBytes((Object)modelMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
                    response.getOutputStream().write(bytes);
                    return false;
                }
            } else {
                CacheUtil.getCache().set("iBase4J:MALICIOUS_REQUEST_TIMES" + user, Integer.valueOf(0), seconds);
            }
        }
        CacheUtil.getCache().set("iBase4J:PREREQUEST" + user, (Serializable)((Object)url), seconds);
        CacheUtil.getCache().set("iBase4J:PREREQUEST_TIME" + user, Long.valueOf(System.currentTimeMillis()), seconds);
        return super.preHandle(request, response, handler);
    }

    private boolean isWhiteReq(String requestUrl) {
        if (this._size == 0) {
            return false;
        }
        for (String urlTemp : this.whiteUrls) {
            if (requestUrl.indexOf(urlTemp.toLowerCase()) <= -1) continue;
            return true;
        }
        return false;
    }

    public MaliciousRequestInterceptor setAllRequest(boolean allRequest) {
        this.allRequest = allRequest;
        return this;
    }

    public MaliciousRequestInterceptor setContainsParamter(boolean containsParamter) {
        this.containsParamter = containsParamter;
        return this;
    }

    public MaliciousRequestInterceptor setMinRequestIntervalTime(int minRequestIntervalTime) {
        this.minRequestIntervalTime = minRequestIntervalTime;
        return this;
    }

    public MaliciousRequestInterceptor setMaxMaliciousTimes(int maxMaliciousTimes) {
        this.maxMaliciousTimes = maxMaliciousTimes;
        return this;
    }
}

