/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.filter;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.filter.CsrfFilter;
import top.ibase4j.core.support.HttpCode;
import top.ibase4j.core.support.Token;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.FileUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;
import top.ibase4j.core.util.TokenUtil;

public class TokenFilter
implements Filter {
    private Logger logger = LogManager.getLogger();
    private String expire;
    private List<String> whiteUrls;
    private int _size = 0;

    public void init(FilterConfig config) throws ServletException {
        String path = CsrfFilter.class.getResource("/").getFile();
        this.whiteUrls = FileUtil.readFile(path + "white/tokenWhite.txt");
        this._size = null == this.whiteUrls ? 0 : this.whiteUrls.size();
        this.expire = config.getInitParameter("expire");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String url;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        boolean filter = DataUtil.isEmpty(PropertiesUtil.getString("token.filter.test"));
        String token = request.getHeader("UUID");
        this.logger.info("UUID==>" + token);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                Token tokenInfo = TokenUtil.getTokenInfo(token);
                if (tokenInfo != null) {
                    request.setAttribute("CURRENT_USER", (Object)tokenInfo.getValue());
                    if (DataUtil.isNotEmpty(this.expire) && System.currentTimeMillis() - tokenInfo.getTime() > Long.valueOf(this.expire) * 1000L) {
                        request.removeAttribute("CURRENT_USER");
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("token\u68c0\u67e5\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            }
        }
        if (this.isWhiteReq((url = request.getRequestURI()).toLowerCase())) {
            chain.doFilter((ServletRequest)request, response);
        } else if (DataUtil.isEmpty(request.getAttribute("CURRENT_USER")) && filter) {
            response.setContentType("text/html; charset=UTF-8");
            LinkedHashMap modelMap = InstanceUtil.newLinkedHashMap();
            modelMap.put("code", HttpCode.UNAUTHORIZED.value().toString());
            modelMap.put("msg", HttpCode.UNAUTHORIZED.msg());
            modelMap.put("timestamp", System.currentTimeMillis());
            String result = JSON.toJSONString(modelMap);
            this.logger.warn(url + " ====> " + result);
            PrintWriter out = response.getWriter();
            out.println(result);
            out.flush();
            out.close();
        } else {
            chain.doFilter((ServletRequest)request, response);
        }
    }

    public void destroy() {
    }

    private boolean isWhiteReq(String requestUrl) {
        if (this._size == 0) {
            return false;
        }
        for (String urlTemp : this.whiteUrls) {
            if (requestUrl.indexOf(urlTemp.toLowerCase()) <= -1) continue;
            return true;
        }
        return false;
    }
}

