/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.config;

import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import top.ibase4j.core.base.provider.IBaseProvider;
import top.ibase4j.core.support.dbcp.ChooseDataSource;
import top.ibase4j.core.support.dbcp.DataSourceAspect;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;

@Configuration
@ConditionalOnClass(value={DruidDataSource.class})
public class DataSourceConfig {
    private Logger logger = LogManager.getLogger();

    public Object dataSourceAspect() {
        String provider = PropertiesUtil.getString("dataSourceAspect.provider");
        boolean single = this.isSingle();
        if (!single && DataUtil.isNotEmpty(provider)) {
            if (new Boolean(provider).booleanValue()) {
                return new top.ibase4j.core.support.dbcp.provider.DataSourceAspect();
            }
            return new DataSourceAspect();
        }
        return null;
    }

    @Bean
    @Conditional(value={EnableAspect.class})
    @ConditionalOnMissingBean(value={IBaseProvider.class})
    public DataSourceAspect serviceAspect() {
        this.logger.info("top.ibase4j.core.support.dbcp.DataSourceAspect");
        return new DataSourceAspect();
    }

    @Bean
    @Conditional(value={EnableAspect.class})
    @ConditionalOnBean(value={IBaseProvider.class})
    public top.ibase4j.core.support.dbcp.provider.DataSourceAspect providerAspect() {
        this.logger.info("top.ibase4j.core.support.dbcp.provider.DataSourceAspect");
        return new top.ibase4j.core.support.dbcp.provider.DataSourceAspect();
    }

    @Bean
    public DataSource dataSource() {
        boolean single = this.isSingle();
        DataSource write = this.getDataSource(false, single);
        HashMap<String, DataSource> targetDataSources = InstanceUtil.newHashMap("write", write);
        if (!single) {
            DataSource read = this.getDataSource(true, single);
            targetDataSources.put("read", read);
        }
        ChooseDataSource dataSource = new ChooseDataSource();
        dataSource.setDefaultTargetDataSource(write);
        dataSource.setTargetDataSources(targetDataSources);
        HashMap<String, String> method = InstanceUtil.newHashMap();
        method.put("write", ",add,insert,create,update,delete,remove,");
        method.put("read", ",get,select,count,list,query,");
        dataSource.setMethodType(method);
        return dataSource;
    }

    @Bean
    public ServletRegistrationBean<StatViewServlet> druidServlet() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean();
        servletRegistrationBean.setServlet((Servlet)new StatViewServlet());
        servletRegistrationBean.addUrlMappings(new String[]{"/druid/*"});
        return servletRegistrationBean;
    }

    private DataSource getDataSource(boolean readOnly, boolean single) {
        DruidDataSource datasource = new DruidDataSource();
        if (!single) {
            if (readOnly) {
                datasource.setUrl(PropertiesUtil.getString("druid.reader.url"));
                datasource.setUsername(PropertiesUtil.getString("druid.reader.username"));
                datasource.setPassword(PropertiesUtil.getString("druid.reader.password"));
            } else {
                datasource.setUrl(PropertiesUtil.getString("druid.writer.url"));
                datasource.setUsername(PropertiesUtil.getString("druid.writer.username"));
                datasource.setPassword(PropertiesUtil.getString("druid.writer.password"));
            }
            datasource.setDefaultReadOnly(Boolean.valueOf(readOnly));
        } else if (DataUtil.isNotEmpty(PropertiesUtil.getString("druid.writer.url")) && DataUtil.isNotEmpty(PropertiesUtil.getString("druid.writer.username"))) {
            datasource.setUrl(PropertiesUtil.getString("druid.writer.url"));
            datasource.setUsername(PropertiesUtil.getString("druid.writer.username"));
            datasource.setPassword(PropertiesUtil.getString("druid.writer.password"));
        }
        Properties properties = new Properties();
        properties.putAll(PropertiesUtil.getProperties());
        datasource.configFromPropety(properties);
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(this.statFilter());
        filters.add(this.wallFilter());
        datasource.setProxyFilters(filters);
        return datasource;
    }

    private StatFilter statFilter() {
        StatFilter statFilter = new StatFilter();
        statFilter.setLogSlowSql(true);
        statFilter.setMergeSql(true);
        statFilter.setSlowSqlMillis(1000L);
        return statFilter;
    }

    private WallFilter wallFilter() {
        WallFilter wallFilter = new WallFilter();
        WallConfig config = new WallConfig();
        config.setMultiStatementAllow(true);
        wallFilter.setConfig(config);
        return wallFilter;
    }

    private boolean isSingle() {
        try {
            return DataUtil.isEmpty(PropertiesUtil.getString("druid.reader.url"));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class EnableAspect
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return DataUtil.isNotEmpty(PropertiesUtil.getString("druid.reader.url"));
        }
    }
}

