/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.base;

import com.baomidou.mybatisplus.plugins.Page;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;
import top.ibase4j.core.base.AbstractController;
import top.ibase4j.core.base.BaseModel;
import top.ibase4j.core.base.IBaseService;

public abstract class BaseController<T extends BaseModel, S extends IBaseService<T>>
extends AbstractController {
    @Autowired
    protected S service;

    public Object query(Map<String, Object> param) {
        return this.query(new ModelMap(), param);
    }

    public Object query(ModelMap modelMap, Map<String, Object> param) {
        if (param.get("keyword") == null && param.get("search") != null) {
            param.put("keyword", param.get("search"));
            param.remove("search");
        }
        Page list = this.service.query(param);
        return this.setSuccessModelMap(modelMap, list);
    }

    public Object queryList(Map<String, Object> param) {
        return this.query(new ModelMap(), param);
    }

    public Object queryList(ModelMap modelMap, Map<String, Object> param) {
        List list = this.service.queryList(param);
        return this.setSuccessModelMap(modelMap, list);
    }

    public Object get(BaseModel param) {
        return this.get(new ModelMap(), param);
    }

    public Object get(ModelMap modelMap, BaseModel param) {
        Object result = this.service.queryById(param.getId());
        return this.setSuccessModelMap(modelMap, result);
    }

    public Object update(T param) {
        return this.update(new ModelMap(), param);
    }

    public Object update(ModelMap modelMap, T param) {
        Long userId = this.getCurrUser();
        if (((BaseModel)param).getId() == null) {
            ((BaseModel)param).setCreateBy(userId);
            ((BaseModel)param).setCreateTime(new Date());
        }
        ((BaseModel)param).setUpdateBy(userId);
        ((BaseModel)param).setUpdateTime(new Date());
        this.service.update(param);
        return this.setSuccessModelMap(modelMap);
    }

    public Object delete(T param) {
        return this.del(new ModelMap(), param);
    }

    public Object delete(ModelMap modelMap, T param) {
        this.service.delete(((BaseModel)param).getId());
        return this.setSuccessModelMap(modelMap);
    }

    public Object del(T param) {
        return this.del(new ModelMap(), param);
    }

    public Object del(ModelMap modelMap, T param) {
        if (((BaseModel)param).getId() != null) {
            this.service.del(((BaseModel)param).getId(), this.getCurrUser());
        }
        if (((BaseModel)param).getIds() != null) {
            this.service.del(((BaseModel)param).getIds(), this.getCurrUser());
        }
        return this.setSuccessModelMap(modelMap);
    }
}

