/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.plugins.Page;
import java.beans.PropertyEditor;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.authz.UnauthorizedException;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import top.ibase4j.core.exception.BaseException;
import top.ibase4j.core.exception.IllegalParameterException;
import top.ibase4j.core.support.DateFormat;
import top.ibase4j.core.support.HttpCode;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.WebUtil;

public abstract class AbstractController {
    protected Logger logger = LogManager.getLogger();

    protected Long getCurrUser() {
        return WebUtil.getCurrentUser();
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((java.text.DateFormat)new DateFormat(), true));
    }

    protected ResponseEntity<ModelMap> setSuccessModelMap() {
        return this.setSuccessModelMap(new ModelMap(), null);
    }

    protected ResponseEntity<ModelMap> setSuccessModelMap(ModelMap modelMap) {
        return this.setSuccessModelMap(modelMap, null);
    }

    protected ResponseEntity<ModelMap> setSuccessModelMap(Object data) {
        return this.setModelMap(new ModelMap(), HttpCode.OK, data);
    }

    protected ResponseEntity<ModelMap> setSuccessModelMap(ModelMap modelMap, Object data) {
        return this.setModelMap(modelMap, HttpCode.OK, data);
    }

    protected ResponseEntity<ModelMap> setModelMap(HttpCode code) {
        return this.setModelMap(new ModelMap(), code, null);
    }

    protected ResponseEntity<ModelMap> setModelMap(ModelMap modelMap, HttpCode code) {
        return this.setModelMap(modelMap, code, null);
    }

    protected ResponseEntity<ModelMap> setModelMap(HttpCode code, Object data) {
        return this.setModelMap(new ModelMap(), code, data);
    }

    protected ResponseEntity<ModelMap> setModelMap(ModelMap modelMap, HttpCode code, Object data) {
        if (!modelMap.isEmpty()) {
            LinkedHashMap map = InstanceUtil.newLinkedHashMap();
            map.putAll(modelMap);
            modelMap.clear();
            for (String key : map.keySet()) {
                if (key.startsWith("org.springframework.validation.BindingResult") || key.equals("void")) continue;
                modelMap.put((Object)key, map.get(key));
            }
        }
        if (data != null) {
            if (data instanceof Page) {
                Page page = (Page)data;
                modelMap.put((Object)"rows", (Object)page.getRecords());
                modelMap.put((Object)"current", (Object)page.getCurrent());
                modelMap.put((Object)"size", (Object)page.getSize());
                modelMap.put((Object)"pages", (Object)page.getPages());
                modelMap.put((Object)"total", (Object)page.getTotal());
            } else if (data instanceof List) {
                modelMap.put((Object)"rows", data);
                modelMap.put((Object)"total", (Object)((List)data).size());
            } else {
                modelMap.put((Object)"data", data);
            }
        }
        modelMap.put((Object)"code", (Object)code.value().toString());
        modelMap.put((Object)"msg", (Object)code.msg());
        modelMap.put((Object)"timestamp", (Object)System.currentTimeMillis());
        this.logger.info("RESPONSE : " + JSON.toJSONString((Object)modelMap));
        return ResponseEntity.ok((Object)modelMap);
    }

    @ExceptionHandler(value={Exception.class})
    public void exceptionHandler(HttpServletRequest request, HttpServletResponse response, Exception ex) throws Exception {
        this.logger.error("OH,MY GOD! SOME ERRORS OCCURED! AS FOLLOWS :", (Throwable)ex);
        ModelMap modelMap = new ModelMap();
        if (ex instanceof BaseException) {
            ((BaseException)ex).handler(modelMap);
        } else if (ex instanceof IllegalArgumentException) {
            new IllegalParameterException(ex.getMessage()).handler(modelMap);
        } else if (ex instanceof UnauthorizedException) {
            modelMap.put((Object)"code", (Object)HttpCode.FORBIDDEN.value().toString());
            modelMap.put((Object)"msg", (Object)HttpCode.FORBIDDEN.msg());
        } else {
            modelMap.put((Object)"code", (Object)HttpCode.INTERNAL_SERVER_ERROR.value().toString());
            String msg = (String)StringUtils.defaultIfBlank((CharSequence)ex.getMessage(), (CharSequence)HttpCode.INTERNAL_SERVER_ERROR.msg());
            this.logger.debug(msg);
            modelMap.put((Object)"msg", (Object)(msg.length() > 100 ? "\u7cfb\u7edf\u8d70\u795e\u4e86,\u8bf7\u7a0d\u5019\u518d\u8bd5." : msg));
        }
        response.setContentType("application/json;charset=UTF-8");
        modelMap.put((Object)"timestamp", (Object)System.currentTimeMillis());
        this.logger.info("RESPONSE : " + JSON.toJSON((Object)modelMap));
        byte[] bytes = JSON.toJSONBytes((Object)modelMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        response.getOutputStream().write(bytes);
    }
}

