/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs.test;

import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.DownloadCallback;
import org.csource.fastdfs.StorageClient1;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;

public class TestLoad {
    public static ConcurrentLinkedQueue file_ids;
    public static int total_download_count;
    public static int success_download_count;
    public static int fail_download_count;
    public static int total_upload_count;
    public static int success_upload_count;
    public static int upload_thread_count;

    private TestLoad() {
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Error: Must have 1 parameter: config filename");
            return;
        }
        System.out.println("java.version=" + System.getProperty("java.version"));
        try {
            int i;
            ClientGlobal.init(args[0]);
            System.out.println("network_timeout=" + ClientGlobal.g_network_timeout + "ms");
            System.out.println("charset=" + ClientGlobal.g_charset);
            file_ids = new ConcurrentLinkedQueue();
            for (i = 0; i < 10; ++i) {
                new UploadThread(i).start();
            }
            for (i = 0; i < 20; ++i) {
                new DownloadThread(i).start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        total_download_count = 0;
        success_download_count = 0;
        fail_download_count = 0;
        total_upload_count = 0;
        success_upload_count = 0;
        upload_thread_count = 0;
    }

    public static class DownloadThread
    extends Thread {
        private int thread_index;
        private static Integer counter_lock = new Integer(0);

        public DownloadThread(int index) {
            this.thread_index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Downloader downloader = new Downloader();
                System.out.println("download thread " + this.thread_index + " start");
                String file_id = "";
                while (upload_thread_count != 0 || file_id != null) {
                    file_id = (String)file_ids.poll();
                    if (file_id == null) {
                        Thread.sleep(10L);
                        continue;
                    }
                    Integer n = counter_lock;
                    synchronized (n) {
                        ++total_download_count;
                    }
                    if (downloader.downloadFile(file_id) == 0) {
                        n = counter_lock;
                        synchronized (n) {
                            ++success_download_count;
                            continue;
                        }
                    }
                    ++fail_download_count;
                }
                for (int i = 0; i < 3 && total_download_count < total_upload_count; ++i) {
                    file_id = (String)file_ids.poll();
                    if (file_id == null) {
                        Thread.sleep(10L);
                        continue;
                    }
                    Integer n = counter_lock;
                    synchronized (n) {
                        ++total_download_count;
                    }
                    if (downloader.downloadFile(file_id) == 0) {
                        n = counter_lock;
                        synchronized (n) {
                            ++success_download_count;
                            continue;
                        }
                    }
                    ++fail_download_count;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println("download thread " + this.thread_index + " exit, total_download_count: " + total_download_count + ", success_download_count: " + success_download_count + ", fail_download_count: " + fail_download_count);
        }
    }

    public static class UploadThread
    extends Thread {
        private int thread_index;

        public UploadThread(int index) {
            this.thread_index = index;
        }

        @Override
        public void run() {
            try {
                ++upload_thread_count;
                Uploader uploader = new Uploader();
                System.out.println("upload thread " + this.thread_index + " start");
                for (int i = 0; i < 50000; ++i) {
                    ++total_upload_count;
                    if (uploader.uploadFile() != 0) continue;
                    ++success_upload_count;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                --upload_thread_count;
            }
            System.out.println("upload thread " + this.thread_index + " exit, total_upload_count: " + total_upload_count + ", success_upload_count: " + success_upload_count + ", total_download_count: " + total_download_count + ", success_download_count: " + success_download_count);
        }
    }

    public static class Downloader {
        public TrackerClient tracker = new TrackerClient();
        public TrackerServer trackerServer = this.tracker.getConnection();
        public DownloadFileDiscard callback = new DownloadFileDiscard();

        public int downloadFile(String file_id) throws Exception {
            StorageServer storageServer = null;
            StorageClient1 client = new StorageClient1(this.trackerServer, storageServer);
            try {
                int errno = client.download_file1(file_id, this.callback);
                if (errno != 0) {
                    System.out.println("Download file fail, file_id: " + file_id + ", error no: " + errno);
                }
                return errno;
            }
            catch (Exception ex) {
                System.out.println("Download file fail, error mesg: " + ex.getMessage());
                return -1;
            }
        }
    }

    public static class Uploader {
        public TrackerClient tracker = new TrackerClient();
        public TrackerServer trackerServer = this.tracker.getConnection();

        public int uploadFile() throws Exception {
            StorageServer storageServer = null;
            StorageClient1 client = new StorageClient1(this.trackerServer, storageServer);
            byte[] file_buff = new byte[2048];
            Arrays.fill(file_buff, (byte)65);
            try {
                String file_id = client.upload_file1(file_buff, "txt", null);
                if (file_id == null) {
                    System.out.println("upload file fail, error code: " + client.getErrorCode());
                    return -1;
                }
                file_ids.offer(file_id);
                return 0;
            }
            catch (Exception ex) {
                System.out.println("upload file fail, error mesg: " + ex.getMessage());
                return -1;
            }
        }
    }

    public static class DownloadFileDiscard
    implements DownloadCallback {
        @Override
        public int recv(long file_size, byte[] data, int bytes) {
            return 0;
        }
    }
}

