/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs.test;

import java.io.FileOutputStream;
import java.io.IOException;
import org.csource.fastdfs.DownloadCallback;

public class DownloadFileWriter
implements DownloadCallback {
    private String filename;
    private FileOutputStream out = null;
    private long current_bytes = 0L;

    public DownloadFileWriter(String filename) {
        this.filename = filename;
    }

    @Override
    public int recv(long file_size, byte[] data, int bytes) {
        try {
            if (this.out == null) {
                this.out = new FileOutputStream(this.filename);
            }
            this.out.write(data, 0, bytes);
            this.current_bytes += (long)bytes;
            if (this.current_bytes == file_size) {
                this.out.close();
                this.out = null;
                this.current_bytes = 0L;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return -1;
        }
        return 0;
    }

    protected void finalize() throws Throwable {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }
}

