/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.web.model;

import cn.hutool.extra.spring.SpringUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.feiniaojin.gracefulresponse.api.ResponseStatusFactory;
import com.feiniaojin.gracefulresponse.data.Response;
import com.feiniaojin.gracefulresponse.data.ResponseStatus;
import com.feiniaojin.gracefulresponse.defaults.DefaultResponseStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="\u54cd\u5e94\u4fe1\u606f")
public class R<T>
implements Response {
    private static final ResponseStatusFactory RESPONSE_STATUS_FACTORY = (ResponseStatusFactory)SpringUtil.getBean(ResponseStatusFactory.class);
    @Schema(description="\u72b6\u6001\u7801", example="0")
    private String code;
    @Schema(description="\u72b6\u6001\u4fe1\u606f", example="ok")
    private String msg;
    @Schema(description="\u662f\u5426\u6210\u529f", example="true")
    private boolean success;
    @Schema(description="\u65f6\u95f4\u6233", example="1691453288000")
    private Long timestamp;
    @Schema(description="\u54cd\u5e94\u6570\u636e")
    private T data;
    private ResponseStatus status = new DefaultResponseStatus();

    public R() {
    }

    public R(ResponseStatus status) {
        this.status = status;
    }

    public R(String code, String msg) {
        this.setCode(code);
        this.setMsg(msg);
    }

    public R(ResponseStatus status, T data) {
        this(status);
        this.setData(data);
    }

    public R(String code, String msg, T data) {
        this(code, msg);
        this.setData(data);
    }

    public void setStatus(ResponseStatus status) {
        this.status = status;
    }

    @JsonIgnore
    public ResponseStatus getStatus() {
        return this.status;
    }

    public void setPayload(Object payload) {
        this.data = payload;
    }

    @JsonIgnore
    public Object getPayload() {
        return this.data;
    }

    public String getCode() {
        return this.status.getCode();
    }

    public void setCode(String code) {
        this.status.setCode(code);
    }

    public String getMsg() {
        return this.status.getMsg();
    }

    public void setMsg(String msg) {
        this.status.setMsg(msg);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return Objects.equals(RESPONSE_STATUS_FACTORY.defaultSuccess().getCode(), this.status.getCode());
    }

    public Long getTimestamp() {
        return System.currentTimeMillis();
    }

    public static R ok() {
        return new R(RESPONSE_STATUS_FACTORY.defaultSuccess());
    }

    public static R ok(Object data) {
        return new R<Object>(RESPONSE_STATUS_FACTORY.defaultSuccess(), data);
    }

    public static R ok(String msg, Object data) {
        R r = R.ok(data);
        r.setMsg(msg);
        return r;
    }

    public static R fail() {
        return new R(RESPONSE_STATUS_FACTORY.defaultError());
    }

    public static R fail(String code, String msg) {
        return new R(code, msg);
    }
}

