/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.web.autoconfigure.response;

import cn.hutool.core.util.ClassUtil;
import java.lang.reflect.Type;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.springdoc.core.parsers.ReturnTypeParser;
import org.springframework.core.MethodParameter;
import top.continew.starter.apidoc.util.ApiDocUtils;
import top.continew.starter.web.autoconfigure.response.GlobalResponseProperties;

public class ApiDocGlobalResponseHandler
implements ReturnTypeParser {
    private final GlobalResponseProperties globalResponseProperties;
    private final Class<Object> responseClass;

    public ApiDocGlobalResponseHandler(GlobalResponseProperties globalResponseProperties) {
        this.globalResponseProperties = globalResponseProperties;
        this.responseClass = ClassUtil.loadClass((String)globalResponseProperties.getResponseClassFullName());
    }

    public Type getReturnType(MethodParameter methodParameter) {
        Type returnType = super.getReturnType(methodParameter);
        if (!ApiDocUtils.hasRestControllerAnnotation((Class)methodParameter.getContainingClass())) {
            return returnType;
        }
        if (returnType.getTypeName().contains(this.globalResponseProperties.getResponseClassFullName())) {
            return returnType;
        }
        if (returnType == Void.TYPE || returnType == Void.class) {
            return TypeUtils.parameterize(this.responseClass, (Type[])new Type[]{Void.class});
        }
        return TypeUtils.parameterize(this.responseClass, (Type[])new Type[]{returnType});
    }
}

