/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.trace.filter;

import cn.hutool.core.text.CharSequenceUtil;
import com.yomahub.tlog.context.TLogContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import top.continew.starter.trace.autoconfigure.TraceProperties;
import top.continew.starter.trace.handler.TLogWebCommon;

public class TLogServletFilter
implements Filter {
    private final TraceProperties traceProperties;

    public TLogServletFilter(TraceProperties traceProperties) {
        this.traceProperties = traceProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                try {
                    TLogWebCommon.loadInstance().preHandle(httpServletRequest);
                    String traceIdName = this.traceProperties.getTraceIdName();
                    if (CharSequenceUtil.isNotBlank((CharSequence)traceIdName)) {
                        httpServletResponse.addHeader(traceIdName, TLogContext.getTraceId());
                    }
                    chain.doFilter(request, response);
                }
                finally {
                    TLogWebCommon.loadInstance().afterCompletion();
                }
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

