/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.messaging.mail.core;

import java.util.Properties;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import top.continew.starter.core.util.validation.ValidationUtils;
import top.continew.starter.messaging.mail.core.MailConfig;

public interface MailConfigurer {
    public MailConfig getMailConfig();

    default public void apply(MailConfig mailConfig, JavaMailSenderImpl sender) {
        String protocolLowerCase = mailConfig.getProtocol().toLowerCase();
        ValidationUtils.throwIfNotEqual((Object)"smtp", (Object)protocolLowerCase, (String)"\u90ae\u4ef6\u914d\u7f6e\u4e0d\u6b63\u786e\uff1a\u4e0d\u652f\u6301\u7684\u90ae\u4ef6\u53d1\u9001\u534f\u8bae: %s".formatted(mailConfig.getProtocol()), (Object[])new Object[0]);
        sender.setProtocol(mailConfig.getProtocol());
        ValidationUtils.throwIfBlank((CharSequence)mailConfig.getHost(), (String)"\u90ae\u4ef6\u914d\u7f6e\u4e0d\u6b63\u786e\uff1a\u670d\u52a1\u5668\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        sender.setHost(mailConfig.getHost());
        ValidationUtils.throwIfNull((Object)mailConfig.getPort(), (String)"\u90ae\u4ef6\u914d\u7f6e\u4e0d\u6b63\u786e\uff1a\u670d\u52a1\u5668\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        sender.setPort(mailConfig.getPort().intValue());
        ValidationUtils.throwIfBlank((CharSequence)mailConfig.getUsername(), (String)"\u90ae\u4ef6\u914d\u7f6e\u4e0d\u6b63\u786e\uff1a\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        sender.setUsername(mailConfig.getUsername());
        ValidationUtils.throwIfBlank((CharSequence)mailConfig.getPassword(), (String)"\u90ae\u4ef6\u914d\u7f6e\u4e0d\u6b63\u786e\uff1a\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        sender.setPassword(mailConfig.getPassword());
        if (mailConfig.getDefaultEncoding() != null) {
            sender.setDefaultEncoding(mailConfig.getDefaultEncoding().name());
        }
        Properties javaMailProperties = new Properties();
        if (!mailConfig.getProperties().isEmpty()) {
            javaMailProperties.putAll(mailConfig.getProperties());
            javaMailProperties.put("mail.from", mailConfig.getFrom());
        }
        javaMailProperties.put("mail.smtp.auth", (Object)true);
        if (mailConfig.isSslEnabled()) {
            ValidationUtils.throwIfNull((Object)mailConfig.getSslPort(), (String)"\u90ae\u4ef6\u914d\u7f6e\u4e0d\u6b63\u786e\uff1aSSL\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            javaMailProperties.put("mail.smtp.socketFactory.port", mailConfig.getSslPort());
            javaMailProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        sender.setJavaMailProperties(javaMailProperties);
    }
}

