/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.log.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import top.continew.starter.core.util.ServletUtils;
import top.continew.starter.core.util.SpringWebUtils;
import top.continew.starter.log.model.AccessLogProperties;
import top.continew.starter.log.model.LogProperties;

public class AccessLogUtils {
    private static final List<String> RESOURCE_PATH = List.of("/doc/**", "/v2/api-docs/**", "/v3/api-docs/**", "/webjars/**", "/swagger-resources/**", "/swagger-ui.html");

    private AccessLogUtils() {
    }

    public static String getParam(AccessLogProperties properties) {
        Object params;
        if (!properties.isPrintRequestParam()) {
            return null;
        }
        try {
            params = AccessLogUtils.getAccessLogReqParam();
        }
        catch (Exception e) {
            return null;
        }
        if (ObjectUtil.isEmpty((Object)params)) {
            return null;
        }
        if (properties.isParamSensitive()) {
            params = AccessLogUtils.processSensitiveParams(params, properties.getSensitiveParams());
        }
        if (properties.isLongParamTruncate()) {
            params = AccessLogUtils.processTruncateLongParams(params, properties.getLongParamThreshold(), properties.getLongParamMaxLength(), properties.getLongParamSuffix());
        }
        return JSONUtil.toJsonStr((Object)params);
    }

    public static boolean exclusionPath(LogProperties properties, String path) {
        return properties.isMatch(path) || RESOURCE_PATH.stream().anyMatch(resourcePath -> SpringWebUtils.isMatch((String)path, (String)resourcePath));
    }

    private static Object processSensitiveParams(Object params, List<String> sensitiveParams) {
        if (params instanceof Map) {
            return AccessLogUtils.filterSensitiveParams((Map)params, sensitiveParams);
        }
        if (params instanceof List) {
            return ((List)params).stream().filter(item -> item instanceof Map).map(item -> AccessLogUtils.filterSensitiveParams((Map)item, sensitiveParams)).collect(Collectors.toList());
        }
        return params;
    }

    private static Map<String, Object> filterSensitiveParams(Map<String, Object> params, List<String> sensitiveParams) {
        if (params == null || params.isEmpty() || sensitiveParams == null || sensitiveParams.isEmpty()) {
            return params;
        }
        HashMap<String, Object> filteredParams = new HashMap<String, Object>(params);
        for (String sensitiveKey : sensitiveParams) {
            if (!filteredParams.containsKey(sensitiveKey)) continue;
            filteredParams.put(sensitiveKey, "***");
        }
        return filteredParams;
    }

    private static Object processTruncateLongParams(Object params, int threshold, int maxLength, String suffix) {
        if (params instanceof Map) {
            return AccessLogUtils.truncateLongParams((Map)params, threshold, maxLength, suffix);
        }
        if (params instanceof List) {
            return ((List)params).stream().filter(Map.class::isInstance).map(item -> AccessLogUtils.truncateLongParams((Map)item, threshold, maxLength, suffix)).collect(Collectors.toList());
        }
        return params;
    }

    private static Map<String, Object> truncateLongParams(Map<String, Object> params, int threshold, int maxLength, String suffix) {
        if (params == null || params.isEmpty()) {
            return params;
        }
        HashMap<String, Object> truncatedParams = new HashMap<String, Object>(params);
        for (Map.Entry entry : truncatedParams.entrySet()) {
            String strValue;
            Object value = entry.getValue();
            if (!(value instanceof String) || (strValue = (String)value).length() <= threshold) continue;
            entry.setValue((CallSite)((Object)(strValue.substring(0, Math.min(strValue.length(), maxLength)) + suffix)));
        }
        return truncatedParams;
    }

    private static Object getAccessLogReqParam() {
        String body = ServletUtils.getRequestBody();
        if (CharSequenceUtil.isNotBlank((CharSequence)body) && JSONUtil.isTypeJSON((String)body)) {
            try {
                if (JSONUtil.isTypeJSONArray((String)body)) {
                    return JSONUtil.toBean((String)body, List.class);
                }
                return JSONUtil.toBean((String)body, Map.class);
            }
            catch (Exception e) {
                return null;
            }
        }
        return Collections.unmodifiableMap(ServletUtils.getRequestParams());
    }
}

