/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.log.model;

import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import top.continew.starter.log.enums.Include;
import top.continew.starter.log.model.LogRequest;
import top.continew.starter.log.model.LogResponse;

public class LogRecord {
    private String description;
    private String module;
    private LogRequest request;
    private LogResponse response;
    private Duration timeTaken;
    private final Instant timestamp;
    private String errorMsg;

    public LogRecord(Instant timestamp, LogRequest request, LogResponse response, Duration timeTaken) {
        this.timestamp = timestamp;
        this.request = request;
        this.response = response;
        this.timeTaken = timeTaken;
    }

    public static Started start() {
        return LogRecord.start(Instant.now());
    }

    public static Started start(Instant timestamp) {
        return new Started(timestamp);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public LogRequest getRequest() {
        return this.request;
    }

    public void setRequest(LogRequest request) {
        this.request = request;
    }

    public LogResponse getResponse() {
        return this.response;
    }

    public void setResponse(LogResponse response) {
        this.response = response;
    }

    public Duration getTimeTaken() {
        return this.timeTaken;
    }

    public void setTimeTaken(Duration timeTaken) {
        this.timeTaken = timeTaken;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public static final class Started {
        private final Instant timestamp;

        private Started(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public LogRecord finish(Instant timestamp, Set<Include> includes) {
            LogRequest logRequest = new LogRequest(includes);
            LogResponse logResponse = new LogResponse(includes);
            Duration duration = Duration.between(this.timestamp, timestamp);
            return new LogRecord(this.timestamp, logRequest, logResponse, duration);
        }
    }
}

