/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.log.filter;

import cn.hutool.extra.spring.SpringUtil;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.lang.NonNull;
import org.springframework.web.filter.OncePerRequestFilter;
import top.continew.starter.core.wrapper.RepeatReadRequestWrapper;
import top.continew.starter.core.wrapper.RepeatReadResponseWrapper;
import top.continew.starter.log.model.LogProperties;

public class LogFilter
extends OncePerRequestFilter {
    private final LogProperties logProperties;

    public LogFilter(LogProperties logProperties) {
        this.logProperties = logProperties;
    }

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        if (!this.isFilter(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        boolean isExcludeUri = this.logProperties.isMatch(request.getRequestURI());
        HttpServletRequest requestWrapper = isExcludeUri || !this.isRequestWrapper(request) ? request : new RepeatReadRequestWrapper(request);
        HttpServletResponse responseWrapper = isExcludeUri || !this.isResponseWrapper(response) ? response : new RepeatReadResponseWrapper(response);
        filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        if (responseWrapper instanceof RepeatReadResponseWrapper) {
            RepeatReadResponseWrapper wrappedResponse = (RepeatReadResponseWrapper)responseWrapper;
            wrappedResponse.copyBodyToResponse();
        }
    }

    private boolean isFilter(HttpServletRequest request) {
        if (!this.isRequestValid(request)) {
            return false;
        }
        ServerProperties serverProperties = (ServerProperties)SpringUtil.getBean(ServerProperties.class);
        return !request.getRequestURI().equals(serverProperties.getError().getPath());
    }

    private boolean isRequestValid(HttpServletRequest request) {
        try {
            new URI(request.getRequestURL().toString());
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private boolean isRequestWrapper(HttpServletRequest request) {
        return !(request instanceof RepeatReadRequestWrapper);
    }

    private boolean isResponseWrapper(HttpServletResponse response) {
        return !(response instanceof RepeatReadResponseWrapper);
    }
}

