/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.json.jackson.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import top.continew.starter.json.jackson.exception.JSONException;

public class JSONUtils {
    private static final ObjectMapper OBJECT_MAPPER = (ObjectMapper)SpringUtil.getBean(ObjectMapper.class);

    private JSONUtils() {
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static JsonNode parseObj(Object obj) {
        if (obj == null) {
            return null;
        }
        return OBJECT_MAPPER.valueToTree(obj);
    }

    public static String toJsonStr(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JSONException(e);
        }
    }

    public static <T> T toBean(String jsonString, Class<T> beanClass) {
        if (CharSequenceUtil.isBlank((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(jsonString, beanClass);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static <T> List<T> toList(String jsonStr, Class<T> elementType) {
        if (jsonStr == null || jsonStr.trim().isEmpty()) {
            return new ArrayList(0);
        }
        try {
            return (List)OBJECT_MAPPER.readValue(jsonStr, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, elementType));
        }
        catch (IOException e) {
            throw new JSONException("Failed to parse JSON string to list", e);
        }
    }

    public static <T> List<T> toList(JsonNode jsonNode, Class<T> elementType) {
        if (jsonNode == null || jsonNode.isNull()) {
            return new ArrayList(0);
        }
        try {
            return (List)OBJECT_MAPPER.convertValue((Object)jsonNode, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, elementType));
        }
        catch (IllegalArgumentException e) {
            throw new JSONException("Failed to convert JSON to list", e);
        }
    }

    public static boolean isTypeJSON(String str) {
        return JSONUtils.isTypeJSONObject(str) || JSONUtils.isTypeJSONArray(str);
    }

    public static boolean isTypeJSONObject(String str) {
        if (CharSequenceUtil.isBlank((CharSequence)str)) {
            return false;
        }
        return CharSequenceUtil.isWrap((CharSequence)CharSequenceUtil.trim((CharSequence)str), (char)'{', (char)'}');
    }

    public static boolean isTypeJSONArray(String str) {
        if (CharSequenceUtil.isBlank((CharSequence)str)) {
            return false;
        }
        return CharSequenceUtil.isWrap((CharSequence)CharSequenceUtil.trim((CharSequence)str), (char)'[', (char)']');
    }
}

