/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.json.jackson.autoconfigure;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.DurationDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.DurationSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.InstantSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import top.continew.starter.core.enums.BaseEnum;
import top.continew.starter.core.util.GeneralPropertySourceFactory;
import top.continew.starter.json.jackson.autoconfigure.JacksonExtensionProperties;
import top.continew.starter.json.jackson.serializer.BaseEnumDeserializer;
import top.continew.starter.json.jackson.serializer.BaseEnumSerializer;
import top.continew.starter.json.jackson.serializer.BigNumberSerializer;
import top.continew.starter.json.jackson.serializer.SimpleDeserializersWrapper;

@AutoConfiguration
@EnableConfigurationProperties(value={JacksonExtensionProperties.class})
@PropertySource(value={"classpath:default-json-jackson.yml"}, factory=GeneralPropertySourceFactory.class)
public class JacksonAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JacksonAutoConfiguration.class);
    private final JacksonExtensionProperties properties;

    public JacksonAutoConfiguration(JacksonExtensionProperties properties) {
        this.properties = properties;
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer() {
        return builder -> {
            JavaTimeModule javaTimeModule = this.javaTimeModule();
            SimpleModule baseEnumModule = this.baseEnumModule();
            SimpleModule bigNumberModule = this.bigNumberModule();
            builder.timeZone(TimeZone.getDefault());
            builder.modules(new Module[]{javaTimeModule, baseEnumModule, bigNumberModule});
            log.debug("[ContiNew Starter] - Auto Configuration 'Jackson' completed initialization.");
        };
    }

    private JavaTimeModule javaTimeModule() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(dateTimeFormatter));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(dateTimeFormatter));
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(dateFormatter));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(dateFormatter));
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(timeFormatter));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(timeFormatter));
        javaTimeModule.addSerializer(Instant.class, (JsonSerializer)InstantSerializer.INSTANCE);
        javaTimeModule.addDeserializer(Instant.class, (JsonDeserializer)InstantDeserializer.INSTANT);
        javaTimeModule.addSerializer(Duration.class, (JsonSerializer)DurationSerializer.INSTANCE);
        javaTimeModule.addDeserializer(Duration.class, (JsonDeserializer)DurationDeserializer.INSTANCE);
        return javaTimeModule;
    }

    private SimpleModule baseEnumModule() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(BaseEnum.class, (JsonSerializer)BaseEnumSerializer.SERIALIZER_INSTANCE);
        SimpleDeserializersWrapper deserializers = new SimpleDeserializersWrapper();
        deserializers.addDeserializer(BaseEnum.class, BaseEnumDeserializer.SERIALIZER_INSTANCE);
        simpleModule.setDeserializers((SimpleDeserializers)deserializers);
        return simpleModule;
    }

    private SimpleModule bigNumberModule() {
        SimpleModule bigNumberModule = new SimpleModule();
        switch (this.properties.getBigNumberSerializeMode()) {
            case FLEXIBLE: {
                bigNumberModule.addSerializer(Long.class, (JsonSerializer)BigNumberSerializer.SERIALIZER_INSTANCE);
                bigNumberModule.addSerializer(Long.TYPE, (JsonSerializer)BigNumberSerializer.SERIALIZER_INSTANCE);
                bigNumberModule.addSerializer(BigInteger.class, (JsonSerializer)BigNumberSerializer.SERIALIZER_INSTANCE);
                break;
            }
            case TO_STRING: {
                bigNumberModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
                bigNumberModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
                bigNumberModule.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
                break;
            }
            default: {
                log.warn("[ContiNew Starter] - Jackson \u5927\u6570\u503c\u5e8f\u5217\u5316\u6a21\u5f0f\uff1aNO_OPERATE\uff0c\u8d85\u8fc7 JS \u8303\u56f4\u7684\u6570\u503c\u4f1a\u635f\u5931\u7cbe\u5ea6");
            }
        }
        return bigNumberModule;
    }
}

