/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.tenant.util;

import cn.hutool.extra.spring.SpringUtil;
import top.continew.starter.extension.tenant.TenantDataSourceHandler;
import top.continew.starter.extension.tenant.config.TenantProvider;
import top.continew.starter.extension.tenant.context.TenantContext;
import top.continew.starter.extension.tenant.context.TenantContextHolder;
import top.continew.starter.extension.tenant.enums.TenantIsolationLevel;

public class TenantUtils {
    private TenantUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Long tenantId, Runnable runnable) {
        if (TenantContextHolder.isTenantDisabled()) {
            runnable.run();
            return;
        }
        TenantContext oldContext = TenantContextHolder.getContext();
        boolean oldIgnore = TenantContextHolder.isIgnore();
        boolean isPush = false;
        try {
            TenantContext newContext = ((TenantProvider)SpringUtil.getBean(TenantProvider.class)).getByTenantId(tenantId.toString(), false);
            TenantContextHolder.setContext(newContext);
            TenantContextHolder.setIgnore(false);
            if (TenantIsolationLevel.DATASOURCE.equals((Object)newContext.getIsolationLevel())) {
                ((TenantDataSourceHandler)SpringUtil.getBean(TenantDataSourceHandler.class)).changeDataSource(newContext.getDataSource());
                isPush = true;
            }
            runnable.run();
        }
        finally {
            TenantContextHolder.setContext(oldContext);
            TenantContextHolder.setIgnore(oldIgnore);
            if (isPush) {
                ((TenantDataSourceHandler)SpringUtil.getBean(TenantDataSourceHandler.class)).poll();
            }
        }
    }

    public static void executeIgnore(Runnable runnable) {
        if (TenantContextHolder.isTenantDisabled() || TenantContextHolder.isIgnore()) {
            runnable.run();
            return;
        }
        try {
            TenantContextHolder.setIgnore(true);
            runnable.run();
        }
        finally {
            TenantContextHolder.setIgnore(false);
        }
    }
}

