/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.tenant.interceptor;

import cn.hutool.core.annotation.AnnotationUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.AnnotatedElement;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import top.continew.starter.extension.tenant.annotation.TenantIgnore;
import top.continew.starter.extension.tenant.autoconfigure.TenantProperties;
import top.continew.starter.extension.tenant.config.TenantProvider;
import top.continew.starter.extension.tenant.context.TenantContextHolder;

public class TenantInterceptor
implements HandlerInterceptor {
    private final TenantProperties tenantProperties;
    private final TenantProvider tenantProvider;

    public TenantInterceptor(TenantProperties tenantProperties, TenantProvider tenantProvider) {
        this.tenantProperties = tenantProperties;
        this.tenantProvider = tenantProvider;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String tenantId = request.getHeader(this.tenantProperties.getTenantIdHeader());
        TenantContextHolder.setContext(this.tenantProvider.getByTenantId(tenantId, true));
        TenantContextHolder.setIgnore(this.isIgnore(handler));
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e) {
        TenantContextHolder.clear();
    }

    private boolean isIgnore(Object handler) {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            TenantIgnore methodAnnotation = (TenantIgnore)handlerMethod.getMethodAnnotation(TenantIgnore.class);
            if (methodAnnotation != null) {
                return true;
            }
            return AnnotationUtil.getAnnotation((AnnotatedElement)handlerMethod.getBeanType(), TenantIgnore.class) != null;
        }
        return false;
    }
}

