/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.tenant.aop;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import top.continew.starter.extension.tenant.annotation.TenantIgnore;
import top.continew.starter.extension.tenant.context.TenantContextHolder;

@Aspect
public class TenantIgnoreAspect {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(tenantIgnore)")
    public Object around(ProceedingJoinPoint joinPoint, TenantIgnore tenantIgnore) throws Throwable {
        boolean oldIgnore = TenantContextHolder.isIgnore();
        if (oldIgnore) {
            return joinPoint.proceed();
        }
        try {
            TenantContextHolder.setIgnore(true);
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            TenantContextHolder.setIgnore(false);
        }
    }
}

