/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.crud.model.query;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Sort;
import top.continew.starter.core.util.validation.ValidationUtils;
import top.continew.starter.data.util.SqlInjectionUtils;

@Schema(description="\u6392\u5e8f\u67e5\u8be2\u6761\u4ef6")
public class SortQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u6392\u5e8f\u6761\u4ef6", example="createTime,desc")
    private String[] sort;

    public SortQuery() {
    }

    public SortQuery(String ... sort) {
        this.sort = sort;
    }

    public SortQuery(String field, Sort.Direction direction) {
        this(field + "," + direction.name().toLowerCase());
    }

    public SortQuery(Sort sort) {
        if (sort == null || sort.isUnsorted()) {
            this.sort = null;
            return;
        }
        this.sort = (String[])sort.stream().map(order -> order.getProperty() + "," + order.getDirection().name().toLowerCase()).toArray(String[]::new);
    }

    public Sort getSort() {
        if (ArrayUtil.isEmpty((Object[])this.sort)) {
            return Sort.unsorted();
        }
        ValidationUtils.throwIf((this.sort.length < 2 ? 1 : 0) != 0, (String)"\u6392\u5e8f\u6761\u4ef6\u65e0\u6548", (Object[])new Object[0]);
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>(this.sort.length);
        if (CharSequenceUtil.contains((CharSequence)this.sort[0], (CharSequence)",")) {
            for (String s : this.sort) {
                List sortList = CharSequenceUtil.splitTrim((CharSequence)s, (CharSequence)",");
                orders.add(this.getOrder((String)sortList.get(0), (String)sortList.get(1)));
            }
        } else {
            orders.add(this.getOrder(this.sort[0], this.sort[1]));
        }
        return Sort.by(orders);
    }

    public void setSort(String[] sort) {
        this.sort = sort;
    }

    private Sort.Order getOrder(String field, String direction) {
        ValidationUtils.throwIf((boolean)SqlInjectionUtils.check((String)field), (String)"\u6392\u5e8f\u5b57\u6bb5\u5305\u542b\u65e0\u6548\u5b57\u7b26", (Object[])new Object[0]);
        return new Sort.Order(Sort.Direction.valueOf((String)direction.toUpperCase()), field);
    }
}

