/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.crud.autoconfigure;

import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPatternParser;
import top.continew.starter.core.util.ExceptionUtils;
import top.continew.starter.extension.crud.annotation.CrudApi;
import top.continew.starter.extension.crud.annotation.CrudRequestMapping;
import top.continew.starter.extension.crud.enums.Api;

public class CrudRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    protected RequestMappingInfo getMappingForMethod(@NonNull Method method, @NonNull Class<?> handlerType) {
        RequestMappingInfo requestMappingInfo = super.getMappingForMethod(method, handlerType);
        if (requestMappingInfo == null) {
            return null;
        }
        if (!handlerType.isAnnotationPresent(CrudRequestMapping.class)) {
            return requestMappingInfo;
        }
        CrudRequestMapping crudRequestMapping = handlerType.getDeclaredAnnotation(CrudRequestMapping.class);
        CrudApi crudApi = (CrudApi)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, CrudApi.class);
        Api[] apis = crudRequestMapping.api();
        if (method.getDeclaringClass() != handlerType) {
            if (!ArrayUtil.contains((Object[])apis, (Object)((Object)((Api)((Object)ExceptionUtils.exToNull(crudApi::value)))))) {
                return null;
            }
        }
        return this.getMappingForMethodWrapper(method, handlerType, crudRequestMapping);
    }

    private RequestMappingInfo getMappingForMethodWrapper(@NonNull Method method, @NonNull Class<?> handlerType, CrudRequestMapping crudRequestMapping) {
        RequestMappingInfo info = this.buildRequestMappingInfo(method);
        if (info != null) {
            String prefix;
            RequestMappingInfo typeInfo = this.buildRequestMappingInfo(handlerType);
            if (typeInfo != null) {
                info = typeInfo.combine(info);
            }
            if ((prefix = crudRequestMapping.value()) != null) {
                RequestMappingInfo.BuilderConfiguration options = new RequestMappingInfo.BuilderConfiguration();
                options.setPatternParser(PathPatternParser.defaultInstance);
                info = RequestMappingInfo.paths((String[])new String[]{prefix}).options(options).build().combine(info);
            }
        }
        return info;
    }

    private RequestMappingInfo buildRequestMappingInfo(AnnotatedElement element) {
        RequestCondition requestCondition;
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, RequestMapping.class);
        if (element instanceof Class) {
            Class clazz = (Class)element;
            requestCondition = this.getCustomTypeCondition(clazz);
        } else {
            requestCondition = this.getCustomMethodCondition((Method)element);
        }
        RequestCondition condition = requestCondition;
        return requestMapping != null ? super.createRequestMappingInfo(requestMapping, condition) : null;
    }
}

