/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.encrypt.password.encoder.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.crypto.argon2.Argon2PasswordEncoder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder;
import top.continew.starter.encrypt.password.encoder.enums.PasswordEncoderAlgorithm;
import top.continew.starter.encrypt.password.encoder.exception.PasswordEncodeException;

public final class PasswordEncoderUtil {
    private static final Map<PasswordEncoderAlgorithm, PasswordEncoder> ENCODER_CACHE = new ConcurrentHashMap<PasswordEncoderAlgorithm, PasswordEncoder>();

    private PasswordEncoderUtil() {
    }

    public static String encode(PasswordEncoderAlgorithm algorithm, String rawPassword) {
        if (algorithm == null) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rawPassword == null) {
            throw new IllegalArgumentException("\u539f\u59cb\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PasswordEncoder encoder = ENCODER_CACHE.get((Object)algorithm);
        if (encoder == null) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5: " + algorithm);
        }
        try {
            return encoder.encode((CharSequence)rawPassword);
        }
        catch (Exception e) {
            throw new PasswordEncodeException("\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static boolean matches(PasswordEncoderAlgorithm algorithm, String rawPassword, String encodedPassword) {
        if (algorithm == null) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rawPassword == null || encodedPassword == null) {
            return false;
        }
        PasswordEncoder encoder = ENCODER_CACHE.get((Object)algorithm);
        if (encoder == null) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5: " + algorithm);
        }
        try {
            return encoder.matches((CharSequence)rawPassword, encodedPassword);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static PasswordEncoder getEncoder(PasswordEncoderAlgorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        return ENCODER_CACHE.get((Object)algorithm);
    }

    static {
        ENCODER_CACHE.put(PasswordEncoderAlgorithm.BCRYPT, (PasswordEncoder)new BCryptPasswordEncoder());
        ENCODER_CACHE.put(PasswordEncoderAlgorithm.SCRYPT, (PasswordEncoder)SCryptPasswordEncoder.defaultsForSpringSecurity_v5_8());
        ENCODER_CACHE.put(PasswordEncoderAlgorithm.PBKDF2, (PasswordEncoder)Pbkdf2PasswordEncoder.defaultsForSpringSecurity_v5_8());
        ENCODER_CACHE.put(PasswordEncoderAlgorithm.ARGON2, (PasswordEncoder)Argon2PasswordEncoder.defaultsForSpringSecurity_v5_8());
    }
}

