/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.encrypt.field.autoconfigure;

import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import top.continew.starter.encrypt.field.autoconfigure.FieldEncryptProperties;
import top.continew.starter.encrypt.field.interceptor.MyBatisDecryptInterceptor;
import top.continew.starter.encrypt.field.interceptor.MyBatisEncryptInterceptor;
import top.continew.starter.encrypt.field.util.EncryptHelper;

@AutoConfiguration
@EnableConfigurationProperties(value={FieldEncryptProperties.class})
@ConditionalOnProperty(prefix="continew-starter.encrypt.field", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class FieldEncryptAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FieldEncryptAutoConfiguration.class);
    private final FieldEncryptProperties properties;

    public FieldEncryptAutoConfiguration(FieldEncryptProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public MyBatisEncryptInterceptor mybatisEncryptInterceptor() {
        return new MyBatisEncryptInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={MyBatisDecryptInterceptor.class})
    public MyBatisDecryptInterceptor mybatisDecryptInterceptor() {
        return new MyBatisDecryptInterceptor();
    }

    @PostConstruct
    public void postConstruct() {
        EncryptHelper.init(this.properties);
        log.debug("[ContiNew Starter] - Auto Configuration 'Encrypt-Field' completed initialization.");
    }
}

