/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.data.autoconfigure.idgenerator;

import cn.hutool.core.net.NetUtil;
import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import me.ahoo.cosid.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ResolvableType;
import top.continew.starter.data.autoconfigure.idgenerator.MyBatisPlusCosIdIdentifierGenerator;

public class MyBatisPlusIdGeneratorConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MyBatisPlusIdGeneratorConfiguration.class);

    private MyBatisPlusIdGeneratorConfiguration() {
    }

    @ConditionalOnProperty(name={"mybatis-plus.extension.id-generator.type"}, havingValue="custom")
    public static class Custom {
        @Bean
        @ConditionalOnMissingBean
        public IdentifierGenerator identifierGenerator() {
            if (log.isErrorEnabled()) {
                log.error("Consider defining a bean of type '{}' in your configuration.", (Object)ResolvableType.forClass(IdentifierGenerator.class));
            }
            throw new NoSuchBeanDefinitionException(IdentifierGenerator.class);
        }
    }

    @ConditionalOnMissingBean(value={IdentifierGenerator.class})
    @ConditionalOnClass(value={IdGenerator.class})
    @ConditionalOnProperty(name={"mybatis-plus.extension.id-generator.type"}, havingValue="cosid")
    public static class CosId {
        @Bean
        public IdentifierGenerator identifierGenerator() {
            return new MyBatisPlusCosIdIdentifierGenerator();
        }

        static {
            log.debug("[ContiNew Starter] - Auto Configuration 'MyBatis Plus-IdGenerator-CosId' completed initialization.");
        }
    }

    @ConditionalOnMissingBean(value={IdentifierGenerator.class})
    @ConditionalOnProperty(name={"mybatis-plus.extension.id-generator.type"}, havingValue="default", matchIfMissing=true)
    public static class Default {
        @Bean
        public IdentifierGenerator identifierGenerator() {
            return new DefaultIdentifierGenerator(NetUtil.getLocalhost());
        }

        static {
            log.debug("[ContiNew Starter] - Auto Configuration 'MyBatis Plus-IdGenerator-Default' completed initialization.");
        }
    }
}

