/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.data.autoconfigure;

import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusPropertiesCustomizer;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import top.continew.starter.core.util.GeneralPropertySourceFactory;
import top.continew.starter.data.autoconfigure.MyBatisPlusExtensionProperties;
import top.continew.starter.data.autoconfigure.idgenerator.MyBatisPlusIdGeneratorConfiguration;
import top.continew.starter.data.handler.CompositeBaseEnumTypeHandler;

@AutoConfiguration
@MapperScan(value={"${mybatis-plus.extension.mapper-package}"})
@EnableTransactionManagement(proxyTargetClass=true)
@EnableConfigurationProperties(value={MyBatisPlusExtensionProperties.class})
@ConditionalOnProperty(prefix="mybatis-plus.extension", name={"enabled"}, havingValue="true")
@PropertySource(value={"classpath:default-data-mybatis-plus.yml"}, factory=GeneralPropertySourceFactory.class)
public class MybatisPlusAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusAutoConfiguration.class);

    @Bean
    public MybatisPlusPropertiesCustomizer mybatisPlusPropertiesCustomizer() {
        return properties -> properties.getConfiguration().setDefaultEnumTypeHandler(CompositeBaseEnumTypeHandler.class);
    }

    @Bean
    @ConditionalOnMissingBean
    public MybatisPlusInterceptor mybatisPlusInterceptor(MyBatisPlusExtensionProperties properties) {
        MyBatisPlusExtensionProperties.PaginationProperties paginationProperties;
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        Map innerInterceptors = SpringUtil.getBeansOfType(InnerInterceptor.class);
        if (!innerInterceptors.isEmpty()) {
            innerInterceptors.values().forEach(arg_0 -> ((MybatisPlusInterceptor)interceptor).addInnerInterceptor(arg_0));
        }
        if ((paginationProperties = properties.getPagination()) != null && paginationProperties.isEnabled()) {
            interceptor.addInnerInterceptor((InnerInterceptor)this.paginationInnerInterceptor(paginationProperties));
        }
        if (properties.isOptimisticLockerEnabled()) {
            interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        }
        if (properties.isBlockAttackPluginEnabled()) {
            interceptor.addInnerInterceptor((InnerInterceptor)new BlockAttackInnerInterceptor());
        }
        return interceptor;
    }

    private PaginationInnerInterceptor paginationInnerInterceptor(MyBatisPlusExtensionProperties.PaginationProperties paginationProperties) {
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor(paginationProperties.getDbType());
        paginationInnerInterceptor.setOverflow(paginationProperties.isOverflow());
        paginationInnerInterceptor.setMaxLimit(paginationProperties.getMaxLimit());
        return paginationInnerInterceptor;
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[ContiNew Starter] - Auto Configuration 'MyBatis Plus' completed initialization.");
    }

    @Configuration
    @Import(value={MyBatisPlusIdGeneratorConfiguration.Default.class, MyBatisPlusIdGeneratorConfiguration.CosId.class, MyBatisPlusIdGeneratorConfiguration.Custom.class})
    protected static class MyBatisPlusIdGeneratorAutoConfiguration {
        protected MyBatisPlusIdGeneratorAutoConfiguration() {
        }
    }
}

