/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.data.util;

import cn.hutool.core.text.CharSequenceUtil;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlInjectionUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlInjectionUtils.class);
    private static final Pattern SQL_SYNTAX_PATTERN = Pattern.compile("(insert|delete|update|select|create|drop|truncate|grant|alter|deny|revoke|call|execute|exec|declare|show|rename|set)\\s+.*(into|from|set|where|table|database|view|index|on|cursor|procedure|trigger|for|password|union|and|or)|(select\\s*\\*\\s*from\\s+)|(and|or)\\s+.*", 2);
    private static final Pattern SQL_COMMENT_PATTERN = Pattern.compile("'.*(or|union|--|#|/\\*|;)", 2);
    private static final String SQL_SYNTAX_KEYWORD = "and |exec |peformance_schema|information_schema|extractvalue|updatexml|geohash|gtid_subset|gtid_subtract|insert |select |delete |update |drop |count |chr |mid |master |truncate |char |declare |;|or |+|--";
    private static final String[] SQL_FUNCTION_PATTERN = new String[]{"chr\\s*\\(", "mid\\s*\\(", " char\\s*\\(", "sleep\\s*\\(", "user\\s*\\(", "show\\s+tables", "user[\\s]*\\([\\s]*\\)", "show\\s+databases", "sleep\\(\\d*\\)", "sleep\\(.*\\)"};
    private static final String MESSAGE_TEMPLATE = "SQL \u6ce8\u5165\u68c0\u67e5: \u68c0\u67e5\u503c=>{}<=\u5b58\u5728 SQL \u6ce8\u5165\u5173\u952e\u5b57, \u5173\u952e\u5b57=>{}<=";

    private SqlInjectionUtils() {
    }

    public static boolean check(String value) {
        return SqlInjectionUtils.check(value, null);
    }

    public static boolean check(String value, String customKeyword) {
        if (CharSequenceUtil.isBlank((CharSequence)value)) {
            return false;
        }
        if (SQL_COMMENT_PATTERN.matcher(value).find() || SQL_SYNTAX_PATTERN.matcher(value).find()) {
            log.warn("SQL \u6ce8\u5165\u68c0\u67e5: \u68c0\u67e5\u503c=>{}<=\u5b58\u5728 SQL \u6ce8\u91ca\u5b57\u7b26\u6216 SQL \u6ce8\u5165\u654f\u611f\u5b57\u7b26", (Object)value);
            return true;
        }
        if (SqlInjectionUtils.checkKeyword(value = value.toLowerCase().trim(), SQL_SYNTAX_KEYWORD.split("\\|"))) {
            return true;
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)customKeyword) && SqlInjectionUtils.checkKeyword(value, customKeyword.split("\\|"))) {
            return true;
        }
        for (String pattern : SQL_FUNCTION_PATTERN) {
            if (!Pattern.matches(".*" + pattern + ".*", value)) continue;
            log.warn(MESSAGE_TEMPLATE, (Object)value, (Object)pattern);
            return true;
        }
        return false;
    }

    private static boolean checkKeyword(String value, String[] keywords) {
        for (String keyword : keywords) {
            if (!value.contains(keyword)) continue;
            log.warn(MESSAGE_TEMPLATE, (Object)value, (Object)keyword);
            return true;
        }
        return false;
    }
}

