/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.core.util.validation;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.extra.spring.SpringUtil;
import jakarta.validation.ConstraintViolationException;
import java.util.Set;
import java.util.function.BooleanSupplier;

public class Validator {
    private static final jakarta.validation.Validator VALIDATOR = (jakarta.validation.Validator)SpringUtil.getBean(jakarta.validation.Validator.class);

    protected Validator() {
    }

    protected static void throwIfNull(Object obj, String message, Class<? extends RuntimeException> exceptionType) {
        Validator.throwIf(obj == null, message, exceptionType);
    }

    protected static void throwIfNotNull(Object obj, String message, Class<? extends RuntimeException> exceptionType) {
        Validator.throwIf(obj != null, message, exceptionType);
    }

    protected static void throwIfEmpty(Object obj, String message, Class<? extends RuntimeException> exceptionType) {
        Validator.throwIf(ObjectUtil.isEmpty((Object)obj), message, exceptionType);
    }

    protected static void throwIfNotEmpty(Object obj, String message, Class<? extends RuntimeException> exceptionType) {
        Validator.throwIf(ObjectUtil.isNotEmpty((Object)obj), message, exceptionType);
    }

    protected static void throwIfBlank(CharSequence str, String message, Class<? extends RuntimeException> exceptionType) {
        Validator.throwIf(CharSequenceUtil.isBlank((CharSequence)str), message, exceptionType);
    }

    protected static void throwIfNotBlank(CharSequence str, String message, Class<? extends RuntimeException> exceptionType) {
        Validator.throwIf(CharSequenceUtil.isNotBlank((CharSequence)str), message, exceptionType);
    }

    protected static void throwIfEqual(Object obj1, Object obj2, String message, Class<? extends RuntimeException> exceptionType) {
        Validator.throwIf(ObjectUtil.equal((Object)obj1, (Object)obj2), message, exceptionType);
    }

    protected static void throwIfNotEqual(Object obj1, Object obj2, String message, Class<? extends RuntimeException> exceptionType) {
        Validator.throwIf(ObjectUtil.notEqual((Object)obj1, (Object)obj2), message, exceptionType);
    }

    protected static void throwIfEqualIgnoreCase(CharSequence str1, CharSequence str2, String message, Class<? extends RuntimeException> exceptionType) {
        Validator.throwIf(CharSequenceUtil.equalsIgnoreCase((CharSequence)str1, (CharSequence)str2), message, exceptionType);
    }

    protected static void throwIfNotEqualIgnoreCase(CharSequence str1, CharSequence str2, String message, Class<? extends RuntimeException> exceptionType) {
        Validator.throwIf(!CharSequenceUtil.equalsIgnoreCase((CharSequence)str1, (CharSequence)str2), message, exceptionType);
    }

    protected static void throwIf(boolean condition, String message, Class<? extends RuntimeException> exceptionType) {
        if (condition) {
            throw (RuntimeException)ReflectUtil.newInstance(exceptionType, (Object[])new Object[]{message});
        }
    }

    protected static void throwIf(BooleanSupplier conditionSupplier, String message, Class<? extends RuntimeException> exceptionType) {
        if (conditionSupplier != null && conditionSupplier.getAsBoolean()) {
            throw (RuntimeException)ReflectUtil.newInstance(exceptionType, (Object[])new Object[]{message});
        }
    }

    public static void validate(Object obj, Class<?> ... groups) {
        Set violations = VALIDATOR.validate(obj, (Class[])groups);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

