/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.core.util.expression;

import java.lang.reflect.Method;
import java.util.function.Function;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import top.continew.starter.core.util.expression.ExpressionInvokeContext;

public class SpelEvaluator
implements Function<Object, Object> {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private final Expression expression;
    private String[] parameterNames;

    public SpelEvaluator(String script, Method defineMethod) {
        this.expression = PARSER.parseExpression(script);
        if (defineMethod.getParameterCount() > 0) {
            this.parameterNames = PARAMETER_NAME_DISCOVERER.getParameterNames(defineMethod);
        }
    }

    @Override
    public Object apply(Object rootObject) {
        StandardEvaluationContext context = new StandardEvaluationContext(rootObject);
        ExpressionInvokeContext invokeContext = (ExpressionInvokeContext)rootObject;
        if (this.parameterNames != null) {
            for (int i = 0; i < this.parameterNames.length; ++i) {
                context.setVariable(this.parameterNames[i], invokeContext.getArgs()[i]);
            }
        }
        return this.expression.getValue((EvaluationContext)context);
    }
}

