/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.core.util;

import cn.hutool.core.util.ReflectUtil;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import top.continew.starter.core.exception.BusinessException;
import top.continew.starter.core.util.CollUtils;

public class ReflectUtils {
    private ReflectUtils() {
    }

    public static List<String> getNonStaticFieldsName(Class<?> beanClass) throws SecurityException {
        List<Field> nonStaticFields = ReflectUtils.getNonStaticFields(beanClass);
        return CollUtils.mapToList(nonStaticFields, Field::getName);
    }

    public static List<Field> getNonStaticFields(Class<?> beanClass) throws SecurityException {
        Field[] fields = ReflectUtil.getFields(beanClass);
        return Arrays.stream(fields).filter(f -> !Modifier.isStatic(f.getModifiers())).collect(Collectors.toList());
    }

    public static <T, K> Function<T, K> createMethodReference(Class<T> clazz, String methodName) {
        try {
            Method method = ReflectUtil.getMethodByName(clazz, (String)methodName);
            method.setAccessible(true);
            return MethodHandleProxies.asInterfaceInstance(Function.class, MethodHandles.lookup().unreflect(method));
        }
        catch (Exception e) {
            throw new BusinessException("\u521b\u5efa\u65b9\u6cd5\u5f15\u7528\u5931\u8d25\uff1a" + clazz.getName() + "." + methodName, e);
        }
    }
}

