/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.core.util;

import cn.hutool.core.collection.CollUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollUtils {
    private CollUtils() {
    }

    public static <T, R> List<R> mapToList(Collection<T> collection, Function<? super T, ? extends R> func) {
        return CollUtils.mapToList(collection, func, true);
    }

    public static <T, R> List<R> mapToList(Collection<T> collection, Function<? super T, ? extends R> func, boolean ignoreNull) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList(0);
        }
        Stream<Object> stream = collection.stream();
        if (ignoreNull) {
            return stream.filter(Objects::nonNull).map(func).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return stream.map(func).collect(Collectors.toList());
    }

    public static <T, R> Set<R> mapToSet(Collection<T> collection, Function<? super T, ? extends R> func) {
        return CollUtils.mapToSet(collection, func, true);
    }

    public static <T, R> Set<R> mapToSet(Collection<T> collection, Function<? super T, ? extends R> func, boolean ignoreNull) {
        if (CollUtil.isEmpty(collection)) {
            return new HashSet(0);
        }
        Stream<Object> stream = collection.stream();
        if (ignoreNull) {
            return stream.filter(Objects::nonNull).map(func).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return stream.map(func).collect(Collectors.toSet());
    }
}

