/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.core.autoconfigure.threadpool;

import cn.hutool.core.util.ArrayUtil;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.task.ThreadPoolTaskExecutorCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import top.continew.starter.core.autoconfigure.threadpool.ThreadPoolExtensionProperties;
import top.continew.starter.core.exception.BaseException;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="spring.task.execution.extension", name={"enabled"}, havingValue="true", matchIfMissing=true)
class TaskExecutionConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TaskExecutionConfiguration.class);
    @Value(value="${spring.task.execution.pool.core-size:#{T(java.lang.Runtime).getRuntime().availableProcessors() + 1}}")
    private int corePoolSize;
    @Value(value="${spring.task.execution.pool.max-size:#{T(java.lang.Runtime).getRuntime().availableProcessors() * 2}}")
    private int maxPoolSize;

    TaskExecutionConfiguration() {
    }

    @Bean
    public ThreadPoolTaskExecutorCustomizer threadPoolTaskExecutorCustomizer(ThreadPoolExtensionProperties properties) {
        return executor -> {
            executor.setCorePoolSize(this.corePoolSize);
            executor.setMaxPoolSize(this.maxPoolSize);
            executor.setRejectedExecutionHandler(properties.getExecution().getRejectedPolicy().getRejectedExecutionHandler());
        };
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[ContiNew Starter] - Auto Configuration 'TaskExecutor' completed initialization.");
    }

    @EnableAsync(proxyTargetClass=true)
    static class AsyncThreadPoolConfigurer
    implements AsyncConfigurer {
        private final ThreadPoolTaskExecutor threadPoolTaskExecutor;

        public AsyncThreadPoolConfigurer(ThreadPoolTaskExecutor threadPoolTaskExecutor) {
            this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        }

        public Executor getAsyncExecutor() {
            return this.threadPoolTaskExecutor;
        }

        public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
            return (throwable, method, objects) -> {
                StringBuilder sb = new StringBuilder();
                sb.append("Exception message: ").append(throwable.getMessage()).append(", Method name: ").append(method.getName());
                if (ArrayUtil.isNotEmpty((Object[])objects)) {
                    sb.append(", Parameter value: ").append(Arrays.toString(objects));
                }
                throw new BaseException(sb.toString());
            };
        }

        @PostConstruct
        public void postConstruct() {
            log.debug("[ContiNew Starter] - Auto Configuration 'TaskExecutor-@Async' completed initialization.");
        }
    }
}

