/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.captcha.behavior.autoconfigure;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.anji.captcha.service.CaptchaService;
import com.anji.captcha.service.impl.CaptchaServiceFactory;
import com.anji.captcha.util.ImageUtils;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import top.continew.starter.captcha.behavior.autoconfigure.BehaviorCaptchaProperties;

@AutoConfiguration
@EnableConfigurationProperties(value={BehaviorCaptchaProperties.class})
@ConditionalOnProperty(prefix="continew-starter.captcha.behavior", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class BehaviorCaptchaAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BehaviorCaptchaAutoConfiguration.class);
    private final BehaviorCaptchaProperties properties;

    public BehaviorCaptchaAutoConfiguration(BehaviorCaptchaProperties properties) {
        this.properties = properties;
    }

    @Bean
    @DependsOn(value={"captchaCacheService"})
    @ConditionalOnMissingBean
    public CaptchaService captchaService() {
        Properties config = new Properties();
        config.put("captcha.cacheType", this.properties.getCacheType().name().toLowerCase());
        config.put("captcha.water.mark", this.properties.getWaterMark());
        config.put("captcha.font.type", this.properties.getFontType());
        config.put("captcha.type", this.properties.getType().getCodeValue());
        config.put("captcha.interference.options", this.properties.getInterferenceOptions());
        config.put("captcha.captchaOriginalPath.jigsaw", CharSequenceUtil.emptyIfNull((CharSequence)this.properties.getJigsawBaseMapPath()));
        config.put("captcha.captchaOriginalPath.pic-click", CharSequenceUtil.emptyIfNull((CharSequence)this.properties.getPicClickBaseMapPath()));
        config.put("captcha.slip.offset", this.properties.getSlipOffset());
        config.put("captcha.aes.status", String.valueOf(this.properties.getEnableAes()));
        config.put("captcha.water.font", this.properties.getWaterFont());
        config.put("captcha.cache.number", this.properties.getCacheNumber());
        config.put("captcha.timing.clear", this.properties.getTimingClear());
        config.put("captcha.history.data.clear.enable", this.properties.getHistoryDataClearEnable());
        config.put("captcha.req.frequency.limit.enable", this.properties.getReqFrequencyLimitEnable());
        config.put("captcha.req.get.lock.limit", this.properties.getReqGetLockLimit());
        config.put("captcha.req.get.lock.seconds", this.properties.getReqGetLockSeconds());
        config.put("captcha.req.get.minute.limit", this.properties.getReqGetMinuteLimit());
        config.put("captcha.req.check.minute.limit", this.properties.getReqCheckMinuteLimit());
        config.put("captcha.req.verify.minute.limit", this.properties.getReqVerifyMinuteLimit());
        config.put("captcha.font.size", this.properties.getFontSize());
        config.put("captcha.font.style", this.properties.getFontStyle());
        config.put("captcha.word.count", (Object)4);
        if (CharSequenceUtil.startWith((CharSequence)this.properties.getJigsawBaseMapPath(), (CharSequence)"classpath:") || CharSequenceUtil.startWith((CharSequence)this.properties.getPicClickBaseMapPath(), (CharSequence)"classpath:")) {
            config.put("captcha.init.original", (Object)true);
            BehaviorCaptchaAutoConfiguration.initializeBaseMap(this.properties.getJigsawBaseMapPath(), this.properties.getPicClickBaseMapPath());
        }
        return CaptchaServiceFactory.getInstance((Properties)config);
    }

    private static void initializeBaseMap(String jigsaw, String picClick) {
        ImageUtils.cacheBootImage(BehaviorCaptchaAutoConfiguration.getResourcesImagesFile(jigsaw + "/original/*.png"), BehaviorCaptchaAutoConfiguration.getResourcesImagesFile(jigsaw + "/slidingBlock/*.png"), BehaviorCaptchaAutoConfiguration.getResourcesImagesFile(picClick + "/*.png"));
    }

    private static Map<String, String> getResourcesImagesFile(String path) {
        HashMap<String, String> imgMap = new HashMap<String, String>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources(path)) {
                String imageName = resource.getFilename();
                byte[] imageValue = FileUtil.readBytes((File)resource.getFile());
                imgMap.put(imageName, Base64.encode((byte[])imageValue));
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u8def\u5f84\u4e3a [{}] \u4e0b\u7684\u56fe\u7247\u6587\u4ef6\u5931\u8d25", (Object)path, (Object)e);
        }
        return imgMap;
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[ContiNew Starter] - Auto Configuration 'Captcha-Behavior' completed initialization.");
    }
}

