/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.version;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import tk.mybatis.mapper.version.NextVersion;
import tk.mybatis.mapper.version.VersionException;

public class VersionUtil {
    private static final Map<Class<? extends NextVersion>, NextVersion> CACHE = new ConcurrentHashMap<Class<? extends NextVersion>, NextVersion>();
    private static final ReentrantLock LOCK = new ReentrantLock();

    public static Object nextVersion(Class<? extends NextVersion> nextVersionClass, Object current) throws VersionException {
        try {
            NextVersion nextVersion;
            if (CACHE.containsKey(nextVersionClass)) {
                nextVersion = CACHE.get(nextVersionClass);
            } else {
                LOCK.lock();
                try {
                    if (!CACHE.containsKey(nextVersionClass)) {
                        CACHE.put(nextVersionClass, nextVersionClass.newInstance());
                    }
                    nextVersion = CACHE.get(nextVersionClass);
                }
                finally {
                    LOCK.unlock();
                }
            }
            return nextVersion.nextVersion(current);
        }
        catch (Exception e) {
            throw new VersionException("\u83b7\u53d6\u4e0b\u4e00\u4e2a\u7248\u672c\u53f7\u5931\u8d25!", e);
        }
    }
}

