/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2018 abel533@gmail.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package tk.mybatis.spring.mapper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

import java.lang.reflect.Method;

/**
 * @author liuzh
 * @since 1.2.1
 */
public abstract class SpringBootBindUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootBindUtil.class);

    public static <T> T bind(Environment environment, Class<T> targetClass, String prefix) {
        try {
            Class<?> binderClass = Class.forName("org.springframework.boot.context.properties.bind.Binder");
            Method getMethod = binderClass.getDeclaredMethod("get", Environment.class);
            Method bindMethod = binderClass.getDeclaredMethod("bind", String.class, Class.class);
            Object binder = getMethod.invoke(null, environment);
            Object bindResult = bindMethod.invoke(binder, prefix, targetClass);

            // Check if the value is bound
            Method isBoundMethod = bindResult.getClass().getDeclaredMethod("isBound");
            boolean isBound = (boolean) isBoundMethod.invoke(bindResult);

            if (isBound) {
                Method getMethodResult = bindResult.getClass().getDeclaredMethod("get");
                return (T) getMethodResult.invoke(bindResult);
            } else {
                return null;
            }
        } catch (Exception e) {
            LOGGER.warn("Bind " + targetClass + " error", e);
            return null;
        }
    }

}
