/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.mapperhelper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.session.Configuration;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.annotation.RegisterMapper;
import tk.mybatis.mapper.entity.Config;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;
import tk.mybatis.mapper.mapperhelper.resolve.EntityResolve;
import tk.mybatis.mapper.provider.EmptyProvider;
import tk.mybatis.mapper.util.MetaObjectUtil;
import tk.mybatis.mapper.util.MsUtil;
import tk.mybatis.mapper.util.StringUtil;

public class MapperHelper {
    private static final Log log = LogFactory.getLog(MapperHelper.class);
    private List<Class<?>> registerClass = new ArrayList();
    private Map<Class<?>, Collection<MapperTemplate>> registerMapper = new ConcurrentHashMap();
    private Config config = new Config();

    public MapperHelper() {
    }

    public MapperHelper(Properties properties) {
        this();
        this.setProperties(properties);
    }

    private Collection<MapperTemplate> fromMapperClasses(Class<?> mapperClass) {
        Method[] methods;
        ConcurrentHashMap<Class, MapperTemplate> templateMap = new ConcurrentHashMap<Class, MapperTemplate>();
        for (Method method : methods = mapperClass.getDeclaredMethods()) {
            MapperTemplate mapperTemplate;
            Class templateClass = null;
            if (method.isAnnotationPresent(SelectProvider.class)) {
                provider = method.getAnnotation(SelectProvider.class);
                templateClass = provider.type();
            } else if (method.isAnnotationPresent(InsertProvider.class)) {
                provider = method.getAnnotation(InsertProvider.class);
                templateClass = provider.type();
            } else if (method.isAnnotationPresent(DeleteProvider.class)) {
                provider = method.getAnnotation(DeleteProvider.class);
                templateClass = provider.type();
            } else if (method.isAnnotationPresent(UpdateProvider.class)) {
                provider = method.getAnnotation(UpdateProvider.class);
                templateClass = provider.type();
            }
            if (templateClass == null || !MapperTemplate.class.isAssignableFrom(templateClass)) {
                templateClass = EmptyProvider.class;
            }
            try {
                mapperTemplate = templateMap.getOrDefault(templateClass, (MapperTemplate)templateClass.getConstructor(Class.class, MapperHelper.class).newInstance(mapperClass, this));
                templateMap.put(templateClass, mapperTemplate);
            }
            catch (Exception e) {
                log.error("\u5b9e\u4f8b\u5316MapperTemplate\u5bf9\u8c61\u5931\u8d25:" + e, (Throwable)e);
                throw new MapperException("\u5b9e\u4f8b\u5316MapperTemplate\u5bf9\u8c61\u5931\u8d25:" + e.getMessage());
            }
            try {
                mapperTemplate.addMethodMap(method.getName(), templateClass.getMethod(method.getName(), MappedStatement.class));
            }
            catch (NoSuchMethodException e) {
                log.error(templateClass.getName() + "\u4e2d\u7f3a\u5c11" + method.getName() + "\u65b9\u6cd5!", (Throwable)e);
                throw new MapperException(templateClass.getName() + "\u4e2d\u7f3a\u5c11" + method.getName() + "\u65b9\u6cd5!");
            }
        }
        return templateMap.values();
    }

    public void registerMapper(Class<?> mapperClass) {
        Class<?>[] interfaces;
        if (!this.registerMapper.containsKey(mapperClass)) {
            this.registerClass.add(mapperClass);
            this.registerMapper.put(mapperClass, this.fromMapperClasses(mapperClass));
        }
        if ((interfaces = mapperClass.getInterfaces()) != null && interfaces.length > 0) {
            for (Class<?> anInterface : interfaces) {
                this.registerMapper(anInterface);
            }
        }
    }

    public void registerMapper(String mapperClass) {
        try {
            this.registerMapper(Class.forName(mapperClass));
        }
        catch (ClassNotFoundException e) {
            log.error("\u6ce8\u518c\u901a\u7528Mapper[" + mapperClass + "]\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8be5\u901a\u7528Mapper!", (Throwable)e);
            throw new MapperException("\u6ce8\u518c\u901a\u7528Mapper[" + mapperClass + "]\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8be5\u901a\u7528Mapper!");
        }
    }

    public MapperTemplate isMapperMethod(String msId) {
        MapperTemplate mapperTemplate = this.getMapperTemplateByMsId(msId);
        if (mapperTemplate == null) {
            try {
                Class<?> mapperClass = MsUtil.getMapperClass(msId);
                if (mapperClass.isInterface() && this.hasRegisterMapper(mapperClass)) {
                    mapperTemplate = this.getMapperTemplateByMsId(msId);
                }
            }
            catch (Exception e) {
                log.warn("\u7279\u6b8a\u60c5\u51b5: " + e);
            }
        }
        return mapperTemplate;
    }

    public MapperTemplate getMapperTemplateByMsId(String msId) {
        for (Map.Entry<Class<?>, Collection<MapperTemplate>> entry : this.registerMapper.entrySet()) {
            for (MapperTemplate t : entry.getValue()) {
                if (!t.supportMethod(msId)) continue;
                return t;
            }
        }
        return null;
    }

    public boolean isExtendCommonMapper(Class<?> mapperInterface) {
        for (Class<?> mapperClass : this.registerClass) {
            if (!mapperClass.isAssignableFrom(mapperInterface)) continue;
            return true;
        }
        return this.hasRegisterMapper(mapperInterface);
    }

    private boolean hasRegisterMapper(Class<?> mapperInterface) {
        Class<?>[] interfaces = mapperInterface.getInterfaces();
        boolean hasRegisterMapper = false;
        if (interfaces != null && interfaces.length > 0) {
            for (Class<?> anInterface : interfaces) {
                if (anInterface.isAnnotationPresent(RegisterMapper.class)) {
                    hasRegisterMapper = true;
                    if (this.registerMapper.containsKey(anInterface)) continue;
                    this.registerMapper(anInterface);
                    continue;
                }
                if (!this.hasRegisterMapper(anInterface)) continue;
                hasRegisterMapper = true;
            }
        }
        return hasRegisterMapper;
    }

    public void processConfiguration(Configuration configuration) {
        this.processConfiguration(configuration, null);
    }

    public void processConfiguration(Configuration configuration, Class<?> mapperInterface) {
        String prefix = mapperInterface != null ? mapperInterface.getName() : "";
        for (Object object : new ArrayList(configuration.getMappedStatements())) {
            MappedStatement ms;
            if (!(object instanceof MappedStatement) || !(ms = (MappedStatement)object).getId().startsWith(prefix)) continue;
            this.processMappedStatement(ms);
        }
    }

    public void processMappedStatement(MappedStatement ms) {
        MapperTemplate mapperTemplate = this.isMapperMethod(ms.getId());
        if (mapperTemplate != null && ms.getSqlSource() instanceof ProviderSqlSource) {
            this.setSqlSource(ms, mapperTemplate);
        }
        if (ms.getSqlSource() instanceof RawSqlSource && ms.getSqlCommandType() == SqlCommandType.SELECT && ms.getResultMaps() != null && !ms.getResultMaps().isEmpty()) {
            this.setRawSqlSourceMapper(ms);
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
        if (config.getResolveClass() != null) {
            try {
                EntityHelper.setResolve(config.getResolveClass().newInstance());
            }
            catch (Exception e) {
                log.error("\u521b\u5efa " + config.getResolveClass().getName() + " \u5b9e\u4f8b\u5931\u8d25\uff0c\u8bf7\u4fdd\u8bc1\u8be5\u7c7b\u6709\u9ed8\u8ba4\u7684\u6784\u9020\u65b9\u6cd5!", (Throwable)e);
                throw new MapperException("\u521b\u5efa " + config.getResolveClass().getName() + " \u5b9e\u4f8b\u5931\u8d25\uff0c\u8bf7\u4fdd\u8bc1\u8be5\u7c7b\u6709\u9ed8\u8ba4\u7684\u6784\u9020\u65b9\u6cd5!", e);
            }
        }
        if (config.getMappers() != null && config.getMappers().size() > 0) {
            for (Class mapperClass : config.getMappers()) {
                this.registerMapper(mapperClass);
            }
        }
    }

    public void setProperties(Properties properties) {
        String mapper;
        String resolveClass;
        this.config.setProperties(properties);
        if (properties != null && StringUtil.isNotEmpty(resolveClass = properties.getProperty("resolveClass"))) {
            try {
                EntityHelper.setResolve((EntityResolve)Class.forName(resolveClass).newInstance());
            }
            catch (Exception e) {
                log.error("\u521b\u5efa " + resolveClass + " \u5b9e\u4f8b\u5931\u8d25!", (Throwable)e);
                throw new MapperException("\u521b\u5efa " + resolveClass + " \u5b9e\u4f8b\u5931\u8d25!", e);
            }
        }
        if (properties != null && StringUtil.isNotEmpty(mapper = properties.getProperty("mappers"))) {
            String[] mappers;
            for (String mapperClass : mappers = mapper.split(",")) {
                if (mapperClass.length() <= 0) continue;
                this.registerMapper(mapperClass);
            }
        }
    }

    public void setSqlSource(MappedStatement ms, MapperTemplate mapperTemplate) {
        try {
            if (mapperTemplate != null) {
                mapperTemplate.setSqlSource(ms);
            }
        }
        catch (Exception e) {
            throw new MapperException(e);
        }
    }

    public void setRawSqlSourceMapper(MappedStatement ms) {
        EntityTable entityTable = EntityHelper.getEntityTableOrNull(((ResultMap)ms.getResultMaps().get(0)).getType());
        if (entityTable != null) {
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            ResultMap resultMap = entityTable.getResultMap(ms.getConfiguration());
            if (resultMap != null) {
                resultMaps.add(resultMap);
                MetaObject metaObject = MetaObjectUtil.forObject(ms);
                metaObject.setValue("resultMaps", Collections.unmodifiableList(resultMaps));
            }
        }
    }
}

