/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.temporal.fillers;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TemporalRangeIterable<T extends Temporal>
implements Iterable<T> {
    private final T from;
    private final T to;
    private final long by;
    private final TemporalUnit byUnit;
    private final boolean including;
    private final int count;

    private TemporalRangeIterable(T from, T to, boolean including, long by, TemporalUnit byUnit, int count) {
        this.from = from;
        this.to = to;
        this.including = including;
        this.by = by;
        this.byUnit = byUnit;
        this.count = count;
    }

    private static <T extends Temporal> TemporalRangeIterable<T> range(T from, T to, long by, TemporalUnit byUnit, int count) {
        return new TemporalRangeIterable<T>(from, to, false, by, byUnit, count);
    }

    public static <T extends Temporal> TemporalRangeIterable<T> range(T from, T to, long by, TemporalUnit byUnit) {
        return TemporalRangeIterable.range(from, to, by, byUnit, -1);
    }

    public static <T extends Temporal> TemporalRangeIterable<T> range(T from, long by, TemporalUnit byUnit, int count) {
        return TemporalRangeIterable.range(from, null, by, byUnit, count);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            T next;
            int num;
            {
                this.next = TemporalRangeIterable.this.from;
                this.num = 0;
            }

            @Override
            public boolean hasNext() {
                return (TemporalRangeIterable.this.count < 0 || this.num < TemporalRangeIterable.this.count) && (TemporalRangeIterable.this.to == null || this.next.until(TemporalRangeIterable.this.to, TemporalRangeIterable.this.byUnit) > 0L || TemporalRangeIterable.this.including && this.next.equals(TemporalRangeIterable.this.to));
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object current = this.next;
                this.next = this.next.plus(TemporalRangeIterable.this.by, TemporalRangeIterable.this.byUnit);
                ++this.num;
                return current;
            }
        };
    }
}

