/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.DoublePredicate;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.columns.numbers.NumberPredicates;
import tech.tablesaw.filtering.NumberFilterSpec;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface NumberFilters
extends NumberFilterSpec<Selection> {
    public Selection eval(DoublePredicate var1);

    public Selection eval(BiPredicate<Number, Number> var1, Number var2);

    @Override
    default public Selection isEqualTo(double d) {
        return this.eval(NumberPredicates.isEqualTo(d));
    }

    default public Selection isNotEqualTo(double d) {
        return this.eval(NumberPredicates.isNotEqualTo(d));
    }

    @Override
    default public Selection isBetweenExclusive(double start, double end) {
        return this.eval(NumberPredicates.isBetweenExclusive(start, end));
    }

    @Override
    default public Selection isBetweenInclusive(double start, double end) {
        return this.eval(NumberPredicates.isBetweenInclusive(start, end));
    }

    @Override
    default public Selection isGreaterThan(double f) {
        return this.eval(NumberPredicates.isGreaterThan(f));
    }

    @Override
    default public Selection isGreaterThanOrEqualTo(double f) {
        return this.eval(NumberPredicates.isGreaterThanOrEqualTo(f));
    }

    @Override
    default public Selection isLessThan(double f) {
        return this.eval(NumberPredicates.isLessThan(f));
    }

    @Override
    default public Selection isLessThanOrEqualTo(double f) {
        return this.eval(NumberPredicates.isLessThanOrEqualTo(f));
    }

    @Override
    public Selection isIn(Collection<Number> var1);

    @Override
    public Selection isNotIn(Collection<Number> var1);

    @Override
    default public Selection isZero() {
        return this.eval(NumberPredicates.isZero);
    }

    @Override
    default public Selection isPositive() {
        return this.eval(NumberPredicates.isPositive);
    }

    @Override
    default public Selection isNegative() {
        return this.eval(NumberPredicates.isNegative);
    }

    @Override
    default public Selection isNonNegative() {
        return this.eval(NumberPredicates.isNonNegative);
    }

    @Override
    default public Selection isCloseTo(Number target, Number margin) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            double targetValue = target.doubleValue();
            double marginValue = margin.doubleValue();
            double val = this.getDouble(i);
            if (!(val > targetValue - marginValue) || !(val < targetValue + marginValue)) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isMissing();

    @Override
    public Selection isNotMissing();

    @Override
    default public Selection isGreaterThan(NumericColumn<?> d) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getDouble(i) > d.getDouble(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    default public Selection isGreaterThanOrEqualTo(NumericColumn<?> d) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getDouble(i) >= d.getDouble(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    default public Selection isEqualTo(NumericColumn<?> d) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getDouble(i) != d.getDouble(i)) continue;
            results.add(i);
        }
        return results;
    }

    public int size();

    public double getDouble(int var1);

    @Override
    default public Selection isNotEqualTo(NumericColumn<?> d) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getDouble(i) == d.getDouble(i)) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    default public Selection isLessThan(NumericColumn<?> d) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getDouble(i) < d.getDouble(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    default public Selection isLessThanOrEqualTo(NumericColumn<?> d) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getDouble(i) <= d.getDouble(i))) continue;
            results.add(i);
        }
        return results;
    }
}

