/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.SkipColumnType;
import tech.tablesaw.columns.booleans.BooleanColumnType;
import tech.tablesaw.columns.dates.DateColumnType;
import tech.tablesaw.columns.datetimes.DateTimeColumnType;
import tech.tablesaw.columns.instant.InstantColumnType;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.FloatColumnType;
import tech.tablesaw.columns.numbers.IntColumnType;
import tech.tablesaw.columns.numbers.LongColumnType;
import tech.tablesaw.columns.numbers.ShortColumnType;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.columns.strings.TextColumnType;
import tech.tablesaw.columns.times.TimeColumnType;
import tech.tablesaw.io.ReadOptions;

public interface ColumnType {
    public static final Map<String, ColumnType> values = new HashMap<String, ColumnType>();
    public static final ShortColumnType SHORT = ShortColumnType.instance();
    public static final IntColumnType INTEGER = IntColumnType.instance();
    public static final LongColumnType LONG = LongColumnType.instance();
    public static final FloatColumnType FLOAT = FloatColumnType.instance();
    public static final BooleanColumnType BOOLEAN = BooleanColumnType.instance();
    public static final StringColumnType STRING = StringColumnType.instance();
    public static final DoubleColumnType DOUBLE = DoubleColumnType.instance();
    public static final DateColumnType LOCAL_DATE = DateColumnType.instance();
    public static final TimeColumnType LOCAL_TIME = TimeColumnType.instance();
    public static final DateTimeColumnType LOCAL_DATE_TIME = DateTimeColumnType.instance();
    public static final InstantColumnType INSTANT = InstantColumnType.instance();
    public static final TextColumnType TEXT = TextColumnType.instance();
    public static final SkipColumnType SKIP = SkipColumnType.instance();

    public static void register(ColumnType type) {
        values.put(type.name(), type);
    }

    public static ColumnType[] values() {
        return values.values().toArray(new ColumnType[0]);
    }

    public static ColumnType valueOf(String name) {
        Preconditions.checkNotNull((Object)name);
        ColumnType result = values.get(name);
        if (result == null) {
            throw new IllegalArgumentException(name + " is not a registered column type.");
        }
        return result;
    }

    public Column<?> create(String var1);

    public String name();

    public int byteSize();

    public String getPrinterFriendlyName();

    public AbstractColumnParser<?> customParser(ReadOptions var1);

    default public boolean compare(int rowNumber, Column<?> temp, Column<?> original) {
        Object o1 = original.get(rowNumber);
        Object o2 = temp.get(temp.size() - 1);
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    default public boolean compare(int col1Row, Column<?> col1, int col2Row, Column<?> col2) {
        Object o1 = col1.get(col1Row);
        Object o2 = col2.get(col2Row);
        return o1 == null ? o2 == null : o1.equals(o2);
    }
}

