/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.core.processor.sdk;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.exception.PowerJobCheckedException;
import tech.powerjob.common.utils.CollectionUtils;
import tech.powerjob.worker.common.ThreadLocalStore;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.common.utils.TransportUtils;
import tech.powerjob.worker.core.processor.sdk.BasicProcessor;
import tech.powerjob.worker.persistence.TaskDO;
import tech.powerjob.worker.pojo.request.ProcessorMapTaskRequest;

public interface MapProcessor
extends BasicProcessor {
    public static final Logger log = LoggerFactory.getLogger(MapProcessor.class);
    public static final int RECOMMEND_BATCH_SIZE = 200;

    default public void map(List<?> taskList, String taskName) throws PowerJobCheckedException {
        ProcessorMapTaskRequest req;
        boolean requestSucceed;
        if (CollectionUtils.isEmpty(taskList)) {
            return;
        }
        TaskDO task = ThreadLocalStore.getTask();
        WorkerRuntime workerRuntime = ThreadLocalStore.getRuntimeMeta();
        if (taskList.size() > 200) {
            log.warn("[Map-{}] map task size is too large, network maybe overload... please try to split the tasks.", (Object)task.getInstanceId());
        }
        if ("OMS_ROOT_TASK".equals(taskName) || "OMS_LAST_TASK".equals(taskName)) {
            log.warn("[Map-{}] illegal map task name : {}! please do not use 'OMS_ROOT_TASK' or 'OMS_LAST_TASK' as map task name. as a precaution, it will be renamed 'X-{}' automatically.", new Object[]{task.getInstanceId(), taskName, taskName});
            taskName = "X-" + taskName;
        }
        if (!(requestSucceed = TransportUtils.reliableMapTask(req = new ProcessorMapTaskRequest(task, taskList, taskName), task.getAddress(), workerRuntime))) {
            throw new PowerJobCheckedException("map failed for task: " + taskName);
        }
        log.info("[Map-{}] map task[name={},num={}] successfully!", new Object[]{task.getInstanceId(), taskName, taskList.size()});
    }

    default public boolean isRootTask() {
        TaskDO task = ThreadLocalStore.getTask();
        return "OMS_ROOT_TASK".equals(task.getTaskName());
    }
}

