/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.remote.server.self;

import com.google.common.base.Stopwatch;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.server.common.module.ServerInfo;
import tech.powerjob.server.extension.LockService;
import tech.powerjob.server.persistence.remote.model.ServerInfoDO;
import tech.powerjob.server.persistence.remote.repository.ServerInfoRepository;
import tech.powerjob.server.remote.server.self.ServerInfoService;

@Service
public class ServerInfoServiceImpl
implements ServerInfoService {
    private static final Logger log = LoggerFactory.getLogger(ServerInfoServiceImpl.class);
    private final ServerInfo serverInfo = new ServerInfo();
    private final ServerInfoRepository serverInfoRepository;
    private static final long MAX_SERVER_CLUSTER_SIZE = 10000L;
    private static final String SERVER_INIT_LOCK = "server_init_lock";
    private static final int SERVER_INIT_LOCK_MAX_TIME = 15000;

    @Autowired
    public ServerInfoServiceImpl(LockService lockService, ServerInfoRepository serverInfoRepository) {
        String ip = NetUtils.getLocalHost();
        this.serverInfo.setIp(ip);
        this.serverInfo.setBornTime(System.currentTimeMillis());
        this.serverInfoRepository = serverInfoRepository;
        Stopwatch sw = Stopwatch.createStarted();
        while (!lockService.tryLock(SERVER_INIT_LOCK, 15000L)) {
            log.info("[ServerInfoService] waiting for lock: {}", (Object)SERVER_INIT_LOCK);
            CommonUtils.easySleep((long)100L);
        }
        try {
            ServerInfoDO server = serverInfoRepository.findByIp(ip);
            if (server == null) {
                ServerInfoDO newServerInfo = new ServerInfoDO(ip);
                server = (ServerInfoDO)serverInfoRepository.saveAndFlush((Object)newServerInfo);
            } else {
                serverInfoRepository.updateGmtModifiedByIp(ip, new Date());
            }
            if (server.getId() < 10000L) {
                this.serverInfo.setId(server.getId());
            } else {
                long retryServerId = this.retryServerId();
                this.serverInfo.setId(Long.valueOf(retryServerId));
                serverInfoRepository.updateIdByIp(retryServerId, ip);
            }
        }
        catch (Exception e) {
            log.error("[ServerInfoService] init server failed", (Throwable)e);
            throw e;
        }
        finally {
            lockService.unlock(SERVER_INIT_LOCK);
        }
        log.info("[ServerInfoService] ip:{}, id:{}, cost:{}", new Object[]{ip, this.serverInfo.getId(), sw});
    }

    @Scheduled(fixedRate=15000L, initialDelay=15000L)
    public void heartbeat() {
        this.serverInfoRepository.updateGmtModifiedByIp(this.serverInfo.getIp(), new Date());
    }

    private long retryServerId() {
        List serverInfoList = this.serverInfoRepository.findAll();
        log.info("[ServerInfoService] current server record num in database: {}", (Object)serverInfoList.size());
        if ((long)serverInfoList.size() > 10000L) {
            Date oneDayAgo = DateUtils.addDays((Date)new Date(), (int)-1);
            int delNum = this.serverInfoRepository.deleteByGmtModifiedBefore(oneDayAgo);
            log.warn("[ServerInfoService] delete invalid {} server info record before {}", (Object)delNum, (Object)oneDayAgo);
            serverInfoList = this.serverInfoRepository.findAll();
        }
        if ((long)serverInfoList.size() > 10000L) {
            throw new PowerJobException(String.format("The powerjob-server cluster cannot accommodate %d machines, please rebuild another cluster", serverInfoList.size()));
        }
        Set uedServerIds = serverInfoList.stream().map(ServerInfoDO::getId).collect(Collectors.toSet());
        for (long i = 1L; i <= 10000L; ++i) {
            if (uedServerIds.contains(i)) continue;
            log.info("[ServerInfoService] ID[{}] is not used yet, try as new server id", (Object)i);
            return i;
        }
        throw new PowerJobException("impossible");
    }

    @Autowired(required=false)
    public void setBuildProperties(BuildProperties buildProperties) {
        if (buildProperties == null) {
            return;
        }
        String pomVersion = buildProperties.getVersion();
        if (StringUtils.isNotBlank((CharSequence)pomVersion)) {
            this.serverInfo.setVersion(pomVersion);
        }
    }

    @Override
    public ServerInfo fetchServiceInfo() {
        return this.serverInfo;
    }
}

